/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMScope.class)
final class LLVMScopeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMScopeGen() {
    }

    static {
        LibraryExport.register(LLVMScope.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=LLVMScope.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMScope.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMScope);
            return new Uncached();
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMScope);
            return new Cached();
        }

        @GeneratedBy(value=LLVMScope.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMScope) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.LLVMScope'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMScope;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScope)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScope)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScope)receiver).isMemberReadable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMScope arg0Value = (LLVMScope)arg0Value_;
                return arg0Value.readMember(arg1Value, BranchProfile.getUncached());
            }
        }

        @GeneratedBy(value=LLVMScope.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile exception_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMScope) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.LLVMScope'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMScope;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScope)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScope)receiver).getMembers(includeInternal);
            }

            public boolean isMemberReadable(Object receiver, String member) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMScope)receiver).isMemberReadable(member);
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMScope arg0Value = (LLVMScope)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    return arg0Value.readMember(arg1Value, this.exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(LLVMScope arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.exception_ = BranchProfile.create();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readMember(arg1Value, this.exception_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

