/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.function.Supplier;

public final class LLVMSourcePointerType
extends LLVMSourceType {
    private final boolean isReference;
    private final boolean isSafeToDereference;
    @CompilerDirectives.CompilationFinal
    private LLVMSourceType baseType;

    public LLVMSourcePointerType(long size, long align, long offset, boolean isSafeToDereference, boolean isReference, LLVMSourceLocation location) {
        this(LLVMSourceType.UNKNOWN::getName, size, align, offset, LLVMSourceType.UNKNOWN, isSafeToDereference, isReference, location);
    }

    private LLVMSourcePointerType(Supplier<String> nameSupplier, long size, long align, long offset, LLVMSourceType baseType, boolean isSafeToDereference, boolean isReference, LLVMSourceLocation location) {
        super(nameSupplier, size, align, offset, location);
        this.baseType = baseType;
        this.isSafeToDereference = isSafeToDereference | isReference;
        this.isReference = isReference;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    public boolean isSafeToDereference() {
        return this.isSafeToDereference;
    }

    public LLVMSourceType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(LLVMSourceType baseType) {
        CompilerAsserts.neverPartOfCompilation();
        this.baseType = baseType;
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return new LLVMSourcePointerType(this::getName, this.getSize(), this.getAlign(), newOffset, this.baseType, this.isSafeToDereference, this.isReference, this.getLocation());
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public int getElementCount() {
        return 1;
    }

    @Override
    public String getElementName(long i) {
        return this.getBaseType().getElementName(i);
    }

    @Override
    public LLVMSourceType getElementType(long i) {
        return this.getBaseType().getElementType(i);
    }

    @Override
    public LLVMSourceType getElementType(String name) {
        return this.getBaseType().getElementType(name);
    }
}

