/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObjectFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTypedForeignObject.class)
final class LLVMTypedForeignObjectGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);

    private LLVMTypedForeignObjectGen() {
    }

    static {
        LibraryExport.register(LLVMTypedForeignObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports(), new ReferenceLibraryExports(), new NativeTypeLibraryExports()});
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class NativeTypeLibraryExports
    extends LibraryExport<NativeTypeLibrary> {
        private NativeTypeLibraryExports() {
            super(NativeTypeLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected NativeTypeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Uncached();
        }

        protected NativeTypeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends NativeTypeLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object getNativeType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                if (((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.foreign)).hasNativeType(arg0Value.foreign)) {
                    return LLVMTypedForeignObject.GetNativeType.getType(arg0Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.foreign));
                }
                if (!((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.getForeign())).hasNativeType(arg0Value.getForeign())) {
                    return LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.getForeign()));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).hasNativeType();
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends NativeTypeLibrary {
            @Node.Child
            private NativeTypeLibrary receiverforeignNativeTypeLibrary;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @Node.Child
            private Fallback0Data fallback0_cache;

            Cached(Object receiver) {
                this.receiverforeignNativeTypeLibrary = (NativeTypeLibrary)this.insert((Node)NATIVE_TYPE_LIBRARY_.create(((LLVMTypedForeignObject)receiver).foreign));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                }
                return this.receiverforeignNativeTypeLibrary.accepts(((LLVMTypedForeignObject)receiver).foreign);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            public Object getNativeType(Object arg0Value_) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0 && this.receiverforeignNativeTypeLibrary.hasNativeType(arg0Value.foreign)) {
                        return LLVMTypedForeignObject.GetNativeType.getType(arg0Value, this.receiverforeignNativeTypeLibrary);
                    }
                    if ((state & 2) != 0) {
                        Fallback0Data s2_ = this.fallback0_cache;
                        while (s2_ != null) {
                            if (s2_.typeLibrary_.accepts(arg0Value.getForeign()) && !s2_.typeLibrary_.hasNativeType(arg0Value.getForeign())) {
                                return LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, s2_.typeLibrary_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 4) != 0) {
                        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            if (!((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.getForeign())).hasNativeType(arg0Value.getForeign())) {
                                LLVMInteropType.Structured structured = LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.getForeign()));
                                return structured;
                            }
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(LLVMTypedForeignObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    LLVMInteropType.Structured structured;
                    NativeTypeLibrary getType_typeLibrary__ = this.receiverforeignNativeTypeLibrary;
                    if (getType_typeLibrary__.hasNativeType(arg0Value.foreign)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = LLVMTypedForeignObject.GetNativeType.getType(arg0Value, getType_typeLibrary__);
                        return object;
                    }
                    if (exclude == 0) {
                        NativeTypeLibrary typeLibrary__;
                        int count2_ = 0;
                        Fallback0Data s2_ = this.fallback0_cache;
                        if ((state & 2) != 0) {
                            while (s2_ != null && (!s2_.typeLibrary_.accepts(arg0Value.getForeign()) || s2_.typeLibrary_.hasNativeType(arg0Value.getForeign()))) {
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null && !(typeLibrary__ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.create(arg0Value.getForeign()))).hasNativeType(arg0Value.getForeign()) && count2_ < 3) {
                            s2_ = (Fallback0Data)super.insert((Node)new Fallback0Data(this.fallback0_cache));
                            s2_.typeLibrary_ = s2_.insertAccessor(typeLibrary__);
                            this.fallback0_cache = s2_;
                            this.state_ = state |= 2;
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            structured = LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, s2_.typeLibrary_);
                            return structured;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        NativeTypeLibrary fallback1_typeLibrary__ = (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.getForeign());
                        if (!fallback1_typeLibrary__.hasNativeType(arg0Value.getForeign())) {
                            this.exclude_ = exclude |= 1;
                            this.fallback0_cache = null;
                            state &= 0xFFFFFFFD;
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            structured = LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, fallback1_typeLibrary__);
                            return structured;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                Fallback0Data s2_;
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0 && ((s2_ = this.fallback0_cache) == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean hasNativeType(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).hasNativeType();
            }

            @GeneratedBy(value=LLVMTypedForeignObject.class)
            private static final class Fallback0Data
            extends Node {
                @Node.Child
                Fallback0Data next_;
                @Node.Child
                NativeTypeLibrary typeLibrary_;

                Fallback0Data(Fallback0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class ReferenceLibraryExports
    extends LibraryExport<ReferenceLibrary> {
        private ReferenceLibraryExports() {
            super(ReferenceLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected ReferenceLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Uncached();
        }

        protected ReferenceLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached();
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends ReferenceLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                if (arg1Value instanceof LLVMTypedForeignObject) {
                    LLVMTypedForeignObject arg1Value_ = (LLVMTypedForeignObject)arg1Value;
                    return LLVMTypedForeignObject.IsSame.doTyped(arg0Value, arg1Value_, LLVMTypedForeignObjectFactory.CompareForeignNodeGen.getUncached());
                }
                return LLVMTypedForeignObject.IsSame.doGeneric(arg0Value, arg1Value);
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends ReferenceLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private LLVMTypedForeignObject.CompareForeignNode typed_compare_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0 && arg1Value instanceof LLVMTypedForeignObject) {
                        LLVMTypedForeignObject arg1Value_ = (LLVMTypedForeignObject)arg1Value;
                        return LLVMTypedForeignObject.IsSame.doTyped(arg0Value, arg1Value_, this.typed_compare_);
                    }
                    if ((state & 2) != 0 && Cached.fallbackGuard_(state, arg0Value, arg1Value)) {
                        return LLVMTypedForeignObject.IsSame.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeAndSpecialize(LLVMTypedForeignObject arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg1Value instanceof LLVMTypedForeignObject) {
                        LLVMTypedForeignObject arg1Value_ = (LLVMTypedForeignObject)arg1Value;
                        this.typed_compare_ = (LLVMTypedForeignObject.CompareForeignNode)super.insert((Node)LLVMTypedForeignObjectFactory.CompareForeignNodeGen.create());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = LLVMTypedForeignObject.IsSame.doTyped(arg0Value, arg1Value_, this.typed_compare_);
                        return bl;
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = LLVMTypedForeignObject.IsSame.doGeneric(arg0Value, arg1Value);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            private static boolean fallbackGuard_(int state, LLVMTypedForeignObject arg0Value, Object arg1Value) {
                return (state & 1) != 0 || !(arg1Value instanceof LLVMTypedForeignObject);
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Uncached();
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached();
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeI8(arg1Value, arg2Value, LLVMInteropWriteNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeI16(arg1Value, arg2Value, LLVMInteropWriteNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeI32(arg1Value, arg2Value, LLVMInteropWriteNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeGenericI64(arg1Value, arg2Value, LLVMInteropWriteNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeFloat(arg1Value, arg2Value, LLVMInteropWriteNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeDouble(arg1Value, arg2Value, LLVMInteropWriteNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writePointer(Object arg0Value_, long arg1Value, LLVMPointer arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writePointer(arg1Value, arg2Value, LLVMInteropWriteNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private LLVMInteropWriteNode write;
            @Node.Child
            private LLVMTypedForeignObject.ForeignGetTypeNode getType;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    arg0Value.writeI8(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI8Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI8Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value, byte arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeI8(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    arg0Value.writeI16(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI16Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI16Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value, short arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeI16(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    arg0Value.writeI32(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI32Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI32Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value, int arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeI32(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    arg0Value.writeGenericI64(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericI64Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeGenericI64Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value, Object arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeGenericI64(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    arg0Value.writeFloat(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeFloatNode_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value, float arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeFloat(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    arg0Value.writeDouble(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeDoubleNode_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value, double arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeDouble(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writePointer(Object arg0Value_, long arg1Value, LLVMPointer arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    arg0Value.writePointer(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writePointerNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writePointerNode_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value, LLVMPointer arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.write == null) {
                        this.write = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writePointer(arg1Value, arg2Value, this.write, this.getType);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Uncached();
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached();
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readI8(arg1Value, LLVMInteropReadNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readI16(arg1Value, LLVMInteropReadNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readI32(arg1Value, LLVMInteropReadNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readGenericI64(arg1Value, LLVMInteropReadNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readFloat(arg1Value, LLVMInteropReadNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readDouble(arg1Value, LLVMInteropReadNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readPointer(arg1Value, LLVMInteropReadNodeGen.getUncached(), LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private LLVMInteropReadNode read;
            @Node.Child
            private LLVMTypedForeignObject.ForeignGetTypeNode getType;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.readI8(arg1Value, this.read, this.getType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte readI8Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    byte by = arg0Value.readI8(arg1Value, this.read, this.getType);
                    return by;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    return arg0Value.readI16(arg1Value, this.read, this.getType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private short readI16Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    short s = arg0Value.readI16(arg1Value, this.read, this.getType);
                    return s;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    return arg0Value.readI32(arg1Value, this.read, this.getType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int readI32Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = arg0Value.readI32(arg1Value, this.read, this.getType);
                    return n;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    return arg0Value.readGenericI64(arg1Value, this.read, this.getType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readGenericI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readGenericI64Node_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readGenericI64(arg1Value, this.read, this.getType);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    return arg0Value.readFloat(arg1Value, this.read, this.getType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private float readFloatNode_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    float f = arg0Value.readFloat(arg1Value, this.read, this.getType);
                    return f;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    return arg0Value.readDouble(arg1Value, this.read, this.getType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private double readDoubleNode_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    double d = arg0Value.readDouble(arg1Value, this.read, this.getType);
                    return d;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    return arg0Value.readPointer(arg1Value, this.read, this.getType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LLVMPointer readPointerNode_AndSpecialize(LLVMTypedForeignObject arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    if (this.getType == null) {
                        this.getType = (LLVMTypedForeignObject.ForeignGetTypeNode)super.insert((Node)LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create());
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMPointer lLVMPointer = arg0Value.readPointer(arg1Value, this.read, this.getType);
                    return lLVMPointer;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return UNCACHED;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.isNull((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.foreign));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.isPointer((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.foreign));
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.asPointer((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.foreign));
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.toNative((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.foreign));
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private InteropLibrary receiverforeignInteropLibrary;

            Cached(Object receiver) {
                this.receiverforeignInteropLibrary = (InteropLibrary)this.insert((Node)INTEROP_LIBRARY_.create(((LLVMTypedForeignObject)receiver).foreign));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                }
                return this.receiverforeignInteropLibrary.accepts(((LLVMTypedForeignObject)receiver).foreign);
            }

            public boolean isNull(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.isNull(this.receiverforeignInteropLibrary);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.isPointer(this.receiverforeignInteropLibrary);
            }

            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.asPointer(this.receiverforeignInteropLibrary);
            }

            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.toNative(this.receiverforeignInteropLibrary);
            }
        }
    }
}

