/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@GenerateUncached
public abstract class LLVMInteropReadNode
extends LLVMNode {
    public static LLVMInteropReadNode create() {
        return LLVMInteropReadNodeGen.create();
    }

    public abstract Object execute(LLVMInteropType.Structured var1, Object var2, long var3, ForeignToLLVM.ForeignToLLVMType var5);

    @Specialization(guards={"type != null"})
    Object doKnownType(LLVMInteropType.Structured type, Object foreign, long offset, ForeignToLLVM.ForeignToLLVMType accessType, @Cached LLVMInteropAccessNode access, @CachedLibrary(limit="3") InteropLibrary interop, @Cached ToLLVM toLLVM, @Cached BranchProfile exception) {
        LLVMInteropAccessNode.AccessLocation location = access.execute(type, foreign, offset);
        return this.read(interop, location, accessType, toLLVM, exception);
    }

    @Specialization(guards={"type == null"}, limit="3")
    Object doUnknownType(LLVMInteropType.Structured type, Object foreign, long offset, ForeignToLLVM.ForeignToLLVMType accessType, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached ToLLVM toLLVM, @Cached BranchProfile exception) {
        LLVMInteropAccessNode.AccessLocation location = new LLVMInteropAccessNode.AccessLocation(foreign, Long.divideUnsigned(offset, accessType.getSizeInBytes()), null);
        return this.read(interop, location, accessType, toLLVM, exception);
    }

    private Object read(InteropLibrary interop, LLVMInteropAccessNode.AccessLocation location, ForeignToLLVM.ForeignToLLVMType accessType, ToLLVM toLLVM, BranchProfile exception) {
        Object ret;
        if (location.identifier instanceof String) {
            String name = (String)location.identifier;
            try {
                ret = interop.readMember(location.base, name);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Member '%s' not found.", name);
            }
            catch (UnknownIdentifierException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Can not read member '%s'.", name);
            }
        }
        long idx = (Long)location.identifier;
        try {
            ret = interop.readArrayElement(location.base, idx);
        }
        catch (InvalidArrayIndexException ex) {
            exception.enter();
            throw new LLVMPolyglotException((Node)this, "Invalid array index %d.", idx);
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException((Node)this, "Can not read array element %d.", idx);
        }
        return toLLVM.executeWithType(ret, location.type, accessType);
    }
}

