/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVMNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMInteropReadNode.class)
public final class LLVMInteropReadNodeGen
extends LLVMInteropReadNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private KnownTypeData knownType_cache;
    @Node.Child
    private UnknownType0Data unknownType0_cache;
    @Node.Child
    private ToLLVM unknownType1_toLLVM_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile unknownType1_exception_;

    private LLVMInteropReadNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
        int state = this.state_;
        if (state != 0) {
            KnownTypeData s1_;
            if ((state & 1) != 0 && (s1_ = this.knownType_cache) != null && arg0Value != null) {
                return this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, s1_.access_, s1_.interop_, s1_.toLLVM_, s1_.exception_);
            }
            if ((state & 2) != 0) {
                UnknownType0Data s2_ = this.unknownType0_cache;
                while (s2_ != null) {
                    if (s2_.interop_.accepts(arg1Value) && arg0Value == null) {
                        return this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, s2_.interop_, s2_.toLLVM_, s2_.exception_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0 && arg0Value == null) {
                return this.unknownType1Boundary(state, arg0Value, arg1Value, arg2Value, arg3Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object unknownType1Boundary(int state, LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            Object object = this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this.unknownType1_toLLVM_, this.unknownType1_exception_);
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value != null) {
                KnownTypeData s1_ = (KnownTypeData)super.insert((Node)new KnownTypeData());
                s1_.access_ = s1_.insertAccessor(LLVMInteropAccessNode.create());
                s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                s1_.toLLVM_ = s1_.insertAccessor(ToLLVMNodeGen.create());
                s1_.exception_ = BranchProfile.create();
                this.knownType_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, s1_.access_, s1_.interop_, s1_.toLLVM_, s1_.exception_);
                return object;
            }
            if (exclude == 0) {
                int count2_ = 0;
                UnknownType0Data s2_ = this.unknownType0_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || s2_.interop_.accepts(arg1Value) && arg0Value == null)) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && arg0Value == null && count2_ < 3) {
                    s2_ = (UnknownType0Data)super.insert((Node)new UnknownType0Data(this.unknownType0_cache));
                    s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value));
                    s2_.toLLVM_ = s2_.insertAccessor(ToLLVMNodeGen.create());
                    s2_.exception_ = BranchProfile.create();
                    this.unknownType0_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, s2_.interop_, s2_.toLLVM_, s2_.exception_);
                    return object;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                if (arg0Value == null) {
                    this.unknownType1_toLLVM_ = (ToLLVM)super.insert((Node)ToLLVMNodeGen.create());
                    this.unknownType1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.unknownType0_cache = null;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this.unknownType1_toLLVM_, this.unknownType1_exception_);
                    return object;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        UnknownType0Data s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.unknownType0_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMInteropReadNode create() {
        return new LLVMInteropReadNodeGen();
    }

    public static LLVMInteropReadNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMInteropReadNode.class)
    private static final class Uncached
    extends LLVMInteropReadNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            if (arg0Value != null) {
                return this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, LLVMInteropAccessNodeGen.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(), ToLLVMNodeGen.getUncached(), BranchProfile.getUncached());
            }
            if (arg0Value == null) {
                return this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), ToLLVMNodeGen.getUncached(), BranchProfile.getUncached());
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMInteropReadNode.class)
    private static final class UnknownType0Data
    extends Node {
        @Node.Child
        UnknownType0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ToLLVM toLLVM_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        UnknownType0Data(UnknownType0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMInteropReadNode.class)
    private static final class KnownTypeData
    extends Node {
        @Node.Child
        LLVMInteropAccessNode access_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ToLLVM toLLVM_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        KnownTypeData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

