/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@GenerateUncached
public abstract class LLVMInteropWriteNode
extends LLVMNode {
    public static LLVMInteropWriteNode create() {
        return LLVMInteropWriteNodeGen.create();
    }

    public abstract void execute(LLVMInteropType.Structured var1, Object var2, long var3, Object var5, ForeignToLLVM.ForeignToLLVMType var6);

    @Specialization(guards={"type != null"})
    void doKnownType(LLVMInteropType.Structured type, Object foreign, long offset, Object value, ForeignToLLVM.ForeignToLLVMType writeType, @Cached LLVMInteropAccessNode access, @CachedLibrary(limit="3") InteropLibrary interop, @Cached ConvertOutgoingNode convertOutgoing, @Cached BranchProfile exception) {
        LLVMInteropAccessNode.AccessLocation location = access.execute(type, foreign, offset);
        this.write(interop, location, convertOutgoing.execute(value, location.type, writeType), exception);
    }

    @Specialization(guards={"type == null"}, limit="3")
    void doUnknownType(LLVMInteropType.Structured type, Object foreign, long offset, Object value, ForeignToLLVM.ForeignToLLVMType writeType, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached ConvertOutgoingNode convertOutgoing, @Cached BranchProfile exception) {
        LLVMInteropAccessNode.AccessLocation location = new LLVMInteropAccessNode.AccessLocation(foreign, Long.divideUnsigned(offset, writeType.getSizeInBytes()), null);
        this.write(interop, location, convertOutgoing.execute(value, null, writeType), exception);
    }

    private void write(InteropLibrary interop, LLVMInteropAccessNode.AccessLocation location, Object value, BranchProfile exception) {
        if (location.identifier instanceof String) {
            String name = (String)location.identifier;
            try {
                interop.writeMember(location.base, name, value);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Can not write member '%s'.", name);
            }
            catch (UnknownIdentifierException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Member '%s' not found.", name);
            }
            catch (UnsupportedTypeException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Wrong type writing to member '%s'.", name);
            }
        }
        long idx = (Long)location.identifier;
        try {
            interop.writeArrayElement(location.base, idx, value);
        }
        catch (InvalidArrayIndexException ex) {
            exception.enter();
            throw new LLVMPolyglotException((Node)this, "Invalid array index %d.", idx);
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException((Node)this, "Can not write array element %d.", idx);
        }
        catch (UnsupportedTypeException ex) {
            exception.enter();
            throw new LLVMPolyglotException((Node)this, "Wrong type writing to array element %d.", idx);
        }
    }

    @GenerateUncached
    static abstract class ConvertOutgoingNode
    extends LLVMNode {
        ConvertOutgoingNode() {
        }

        abstract Object execute(Object var1, LLVMInteropType.Value var2, ForeignToLLVM.ForeignToLLVMType var3);

        @Specialization(limit="3", guards={"outgoingType != null", "cachedOutgoingType == outgoingType.kind.foreignToLLVMType", "type.getSizeInBytes() == cachedOutgoingType.getSizeInBytes()"})
        Object doKnownType(Object value, LLVMInteropType.Value outgoingType, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="outgoingType.kind.foreignToLLVMType") ForeignToLLVM.ForeignToLLVMType cachedOutgoingType, @Cached(parameters={"cachedOutgoingType"}) LLVMDataEscapeNode dataEscape) {
            return dataEscape.executeWithType(value, outgoingType.baseType);
        }

        static boolean typeMismatch(LLVMInteropType.Value outgoingType, ForeignToLLVM.ForeignToLLVMType writeType) {
            if (outgoingType == null) {
                return true;
            }
            return outgoingType.getSize() != (long)writeType.getSizeInBytes();
        }

        @Specialization(limit="3", guards={"typeMismatch(outgoingType, cachedType)", "cachedType == type"})
        Object doUnknownType(Object value, LLVMInteropType.Value outgoingType, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="type") ForeignToLLVM.ForeignToLLVMType cachedType, @Cached(parameters={"type"}) LLVMDataEscapeNode dataEscape) {
            return dataEscape.executeWithTarget(value);
        }
    }
}

