/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToAnyLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=ToAnyLLVM.class)
public final class ToAnyLLVMNodeGen
extends ToAnyLLVM {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private ToAnyLLVMNodeGen() {
    }

    @Override
    public Object executeWithForeignToLLVMType(Object arg0Value, LLVMInteropType.Structured type, ForeignToLLVM.ForeignToLLVMType ftlType) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return Character.valueOf(this.fromChar(arg0Value_));
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return Float.valueOf(this.fromFloat(arg0Value_));
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x400) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
            return this.fromUnknownObject(arg0Value);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
            return this.fromInternal(arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithType(Object arg0Value, LLVMInteropType.Structured type) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return Character.valueOf(this.fromChar(arg0Value_));
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return Float.valueOf(this.fromFloat(arg0Value_));
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x400) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
            return this.fromUnknownObject(arg0Value);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
            return this.fromInternal(arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return Character.valueOf(this.fromChar(arg0Value_));
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return Float.valueOf(this.fromFloat(arg0Value_));
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x400) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
            return this.fromUnknownObject(arg0Value);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
            return this.fromInternal(arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state = this.state_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_ = state |= 1;
            return this.fromInt(arg0Value_);
        }
        if (arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            this.state_ = state |= 2;
            return Character.valueOf(this.fromChar(arg0Value_));
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            this.state_ = state |= 4;
            return this.fromLong(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            this.state_ = state |= 8;
            return this.fromByte(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            this.state_ = state |= 0x10;
            return this.fromShort(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            this.state_ = state |= 0x20;
            return Float.valueOf(this.fromFloat(arg0Value_));
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            this.state_ = state |= 0x40;
            return this.fromDouble(arg0Value_);
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            this.state_ = state |= 0x80;
            return this.fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            this.state_ = state |= 0x100;
            return this.fromString(arg0Value_);
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            this.state_ = state |= 0x200;
            return this.fromPointer(arg0Value_);
        }
        if (ForeignToLLVM.notLLVM(arg0Value)) {
            this.state_ = state |= 0x400;
            return this.fromUnknownObject(arg0Value);
        }
        if (arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
            this.state_ = state |= 0x800;
            return this.fromInternal(arg0Value_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToAnyLLVM create() {
        return new ToAnyLLVMNodeGen();
    }
}

