/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.nodes.factories.LLVMObjectAccessFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMManagedAccessDefaults.FallbackWrite.class)
final class FallbackWriteGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private FallbackWriteGen() {
    }

    static {
        LibraryExport.register(LLVMManagedAccessDefaults.FallbackWrite.class, (LibraryExport[])new LibraryExport[]{new LLVMManagedWriteLibraryExports()});
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackWrite.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, Object.class, true);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            return new Uncached(receiver);
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackWrite.class)
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object arg0Value) {
                return LLVMManagedAccessDefaults.FallbackWrite.isWritable(arg0Value, LLVMObjectAccessFactory.createWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value, long arg1Value, byte arg2Value) {
                LLVMManagedAccessDefaults.FallbackWrite.writeI8(arg0Value, arg1Value, arg2Value, LLVMObjectAccessFactory.createWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value, long arg1Value, short arg2Value) {
                LLVMManagedAccessDefaults.FallbackWrite.writeI16(arg0Value, arg1Value, arg2Value, LLVMObjectAccessFactory.createWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value, long arg1Value, int arg2Value) {
                LLVMManagedAccessDefaults.FallbackWrite.writeI32(arg0Value, arg1Value, arg2Value, LLVMObjectAccessFactory.createWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value, long arg1Value, Object arg2Value) {
                LLVMManagedAccessDefaults.FallbackWrite.writeGenericI64(arg0Value, arg1Value, arg2Value, LLVMObjectAccessFactory.createWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value, long arg1Value, float arg2Value) {
                LLVMManagedAccessDefaults.FallbackWrite.writeFloat(arg0Value, arg1Value, arg2Value, LLVMObjectAccessFactory.createWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value, long arg1Value, double arg2Value) {
                LLVMManagedAccessDefaults.FallbackWrite.writeDouble(arg0Value, arg1Value, arg2Value, LLVMObjectAccessFactory.createWrite());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writePointer(Object arg0Value, long arg1Value, LLVMPointer arg2Value) {
                LLVMManagedAccessDefaults.FallbackWrite.writePointer(arg0Value, arg1Value, arg2Value, LLVMObjectAccessFactory.createWrite());
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackWrite.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private LLVMObjectAccess.LLVMObjectWriteNode write;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isWritable(Object arg0Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 1) != 0) {
                    return LLVMManagedAccessDefaults.FallbackWrite.isWritable(arg0Value, this.write);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isWritableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isWritableNode_AndSpecialize(Object arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode isWritableNode__write___ = LLVMObjectAccessFactory.createWrite();
                    if (isWritableNode__write___ instanceof Node) {
                        super.insert((Node)isWritableNode__write___);
                    }
                    if (this.write == null) {
                        this.write = isWritableNode__write___;
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = LLVMManagedAccessDefaults.FallbackWrite.isWritable(arg0Value, this.write);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public void writeI8(Object arg0Value, long arg1Value, byte arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 2) != 0) {
                    LLVMManagedAccessDefaults.FallbackWrite.writeI8(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI8Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI8Node_AndSpecialize(Object arg0Value, long arg1Value, byte arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode writeI8Node__write___ = LLVMObjectAccessFactory.createWrite();
                    if (writeI8Node__write___ instanceof Node) {
                        super.insert((Node)writeI8Node__write___);
                    }
                    if (this.write == null) {
                        this.write = writeI8Node__write___;
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.FallbackWrite.writeI8(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI16(Object arg0Value, long arg1Value, short arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 4) != 0) {
                    LLVMManagedAccessDefaults.FallbackWrite.writeI16(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI16Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI16Node_AndSpecialize(Object arg0Value, long arg1Value, short arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode writeI16Node__write___ = LLVMObjectAccessFactory.createWrite();
                    if (writeI16Node__write___ instanceof Node) {
                        super.insert((Node)writeI16Node__write___);
                    }
                    if (this.write == null) {
                        this.write = writeI16Node__write___;
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.FallbackWrite.writeI16(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI32(Object arg0Value, long arg1Value, int arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 8) != 0) {
                    LLVMManagedAccessDefaults.FallbackWrite.writeI32(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI32Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI32Node_AndSpecialize(Object arg0Value, long arg1Value, int arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode writeI32Node__write___ = LLVMObjectAccessFactory.createWrite();
                    if (writeI32Node__write___ instanceof Node) {
                        super.insert((Node)writeI32Node__write___);
                    }
                    if (this.write == null) {
                        this.write = writeI32Node__write___;
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.FallbackWrite.writeI32(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeGenericI64(Object arg0Value, long arg1Value, Object arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    LLVMManagedAccessDefaults.FallbackWrite.writeGenericI64(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericI64Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeGenericI64Node_AndSpecialize(Object arg0Value, long arg1Value, Object arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode writeGenericI64Node__write___ = LLVMObjectAccessFactory.createWrite();
                    if (writeGenericI64Node__write___ instanceof Node) {
                        super.insert((Node)writeGenericI64Node__write___);
                    }
                    if (this.write == null) {
                        this.write = writeGenericI64Node__write___;
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.FallbackWrite.writeGenericI64(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeFloat(Object arg0Value, long arg1Value, float arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    LLVMManagedAccessDefaults.FallbackWrite.writeFloat(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeFloatNode_AndSpecialize(Object arg0Value, long arg1Value, float arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode writeFloatNode__write___ = LLVMObjectAccessFactory.createWrite();
                    if (writeFloatNode__write___ instanceof Node) {
                        super.insert((Node)writeFloatNode__write___);
                    }
                    if (this.write == null) {
                        this.write = writeFloatNode__write___;
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.FallbackWrite.writeFloat(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeDouble(Object arg0Value, long arg1Value, double arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    LLVMManagedAccessDefaults.FallbackWrite.writeDouble(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeDoubleNode_AndSpecialize(Object arg0Value, long arg1Value, double arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode writeDoubleNode__write___ = LLVMObjectAccessFactory.createWrite();
                    if (writeDoubleNode__write___ instanceof Node) {
                        super.insert((Node)writeDoubleNode__write___);
                    }
                    if (this.write == null) {
                        this.write = writeDoubleNode__write___;
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.FallbackWrite.writeDouble(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writePointer(Object arg0Value, long arg1Value, LLVMPointer arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state = this.state_;
                if ((state & 0x80) != 0) {
                    LLVMManagedAccessDefaults.FallbackWrite.writePointer(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writePointerNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writePointerNode_AndSpecialize(Object arg0Value, long arg1Value, LLVMPointer arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    LLVMObjectAccess.LLVMObjectWriteNode writePointerNode__write___ = LLVMObjectAccessFactory.createWrite();
                    if (writePointerNode__write___ instanceof Node) {
                        super.insert((Node)writePointerNode__write___);
                    }
                    if (this.write == null) {
                        this.write = writePointerNode__write___;
                    }
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.FallbackWrite.writePointer(arg0Value, arg1Value, arg2Value, this.write);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

