/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64RdtscNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;

public abstract class LLVMAMD64RdtscNode
extends LLVMStatementNode {
    @Node.Child
    private LLVMExpressionNode rdtsc;
    @Node.Child
    private LLVMAMD64WriteTupelNode out;

    public LLVMAMD64RdtscNode(LLVMAMD64WriteTupelNode out) {
        this.out = out;
        this.rdtsc = LLVMAMD64RdtscNodeGen.LLVMAMD64RdtscReadNodeGen.create();
    }

    @Specialization
    protected void doOp(VirtualFrame frame) {
        long value = LLVMTypesGen.asLong(this.rdtsc.executeGeneric(frame));
        long lo = value & 0xFFFFFFFFL;
        long hi = value >> 32 & 0xFFFFFFFFL;
        this.out.execute(frame, lo, hi);
    }

    public static abstract class LLVMAMD64RdtscReadNode
    extends LLVMExpressionNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long doRdtsc() {
            return System.currentTimeMillis();
        }
    }
}

