/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64SarNode;

@GeneratedBy(value=LLVMAMD64SarNode.class)
public final class LLVMAMD64SarNodeFactory {

    @GeneratedBy(value=LLVMAMD64SarNode.LLVMAMD64SarqNode.class)
    public static final class LLVMAMD64SarqNodeGen
    extends LLVMAMD64SarNode.LLVMAMD64SarqNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64SarqNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            byte rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private long executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Long) {
                long leftValue_ = (Long)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    return this.doI64(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64SarNode.LLVMAMD64SarqNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64SarqNodeGen(left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64SarNode.LLVMAMD64SarlNode.class)
    public static final class LLVMAMD64SarlNodeGen
    extends LLVMAMD64SarNode.LLVMAMD64SarlNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64SarlNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            byte rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private int executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    return this.doI32(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64SarNode.LLVMAMD64SarlNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64SarlNodeGen(left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64SarNode.LLVMAMD64SarwNode.class)
    public static final class LLVMAMD64SarwNodeGen
    extends LLVMAMD64SarNode.LLVMAMD64SarwNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64SarwNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            byte rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    return this.doI16(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64SarNode.LLVMAMD64SarwNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64SarwNodeGen(left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64SarNode.LLVMAMD64SarbNode.class)
    public static final class LLVMAMD64SarbNodeGen
    extends LLVMAMD64SarNode.LLVMAMD64SarbNode {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64SarbNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI8(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private byte executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Byte) {
                byte leftValue_ = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    return this.doI8(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64SarNode.LLVMAMD64SarbNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64SarbNodeGen(left, right);
        }
    }
}

