/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAMD64AddressComputationNode
extends LLVMExpressionNode {
    protected final int displacement;

    public LLVMAMD64AddressComputationNode(int displacement) {
        this.displacement = displacement;
    }

    protected static long toLong(int value) {
        return value;
    }

    @NodeChildren(value={@NodeChild(value="base", type=LLVMExpressionNode.class), @NodeChild(value="offset", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64AddressSegmentComputationNode
    extends LLVMAMD64AddressComputationNode {
        public LLVMAMD64AddressSegmentComputationNode() {
            super(0);
        }

        @Specialization
        protected LLVMPointer doLLVMPointer(LLVMPointer base, LLVMNativePointer offset) {
            return base.increment(offset.asNative());
        }

        @Specialization
        protected LLVMPointer doI64(LLVMPointer base, long offset) {
            return base.increment(offset);
        }
    }

    @NodeChild(value="offset", type=LLVMExpressionNode.class)
    public static abstract class LLVMAMD64AddressNoBaseOffsetComputationNode
    extends LLVMAMD64AddressComputationNode {
        private final int shift;

        public LLVMAMD64AddressNoBaseOffsetComputationNode(int displacement, int shift) {
            super(displacement);
            this.shift = shift;
        }

        @Specialization
        protected LLVMNativePointer doInt(int offset) {
            return LLVMNativePointer.create((long)this.displacement + (LLVMAMD64AddressNoBaseOffsetComputationNode.toLong(offset) << this.shift));
        }

        @Specialization
        protected long doLong(long offset) {
            return (long)this.displacement + (offset << this.shift);
        }

        @Specialization
        protected LLVMNativePointer doLLVMNativePointer(LLVMNativePointer offset) {
            return LLVMNativePointer.create((long)this.displacement + (offset.asNative() << this.shift));
        }
    }

    @NodeChildren(value={@NodeChild(value="base", type=LLVMExpressionNode.class), @NodeChild(value="offset", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64AddressOffsetComputationNode
    extends LLVMAMD64AddressComputationNode {
        private final int shift;

        public LLVMAMD64AddressOffsetComputationNode(int displacement, int shift) {
            super(displacement);
            this.shift = shift;
        }

        @Specialization
        protected long doI64(int base, int offset) {
            return LLVMAMD64AddressOffsetComputationNode.toLong(base) + (long)this.displacement + (LLVMAMD64AddressOffsetComputationNode.toLong(offset) << this.shift);
        }

        @Specialization
        protected long doI64(long base, int offset) {
            return base + (long)this.displacement + (LLVMAMD64AddressOffsetComputationNode.toLong(offset) << this.shift);
        }

        @Specialization
        protected long doI64(long base, long offset) {
            return base + (long)this.displacement + (offset << this.shift);
        }

        @Specialization
        protected LLVMPointer doLLVMPointer(LLVMPointer base, int offset) {
            return base.increment((long)this.displacement + (LLVMAMD64AddressOffsetComputationNode.toLong(offset) << this.shift));
        }

        @Specialization
        protected LLVMPointer doLLVMPointer(LLVMPointer base, long offset) {
            return base.increment((long)this.displacement + (offset << this.shift));
        }
    }

    @NodeChild(value="base", type=LLVMExpressionNode.class)
    public static abstract class LLVMAMD64AddressDisplacementComputationNode
    extends LLVMAMD64AddressComputationNode {
        public LLVMAMD64AddressDisplacementComputationNode(int displacement) {
            super(displacement);
        }

        @Specialization
        protected LLVMPointer doLLVMPointer(LLVMPointer base) {
            return base.increment(this.displacement);
        }

        @Specialization
        protected long doInt(int base) {
            return LLVMAMD64AddressDisplacementComputationNode.toLong(base) + (long)this.displacement;
        }

        @Specialization
        protected long doLong(long base) {
            return base + (long)this.displacement;
        }
    }
}

