/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64AddressComputationNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMAMD64AddressComputationNode.class)
public final class LLVMAMD64AddressComputationNodeFactory {

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode.class)
    public static final class LLVMAMD64AddressSegmentComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode {
        @Node.Child
        private LLVMExpressionNode base_;
        @Node.Child
        private LLVMExpressionNode offset_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AddressSegmentComputationNodeGen(LLVMExpressionNode base, LLVMExpressionNode offset) {
            this.base_ = base;
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state, baseValue_);
            }
            return this.executeGeneric_generic1(frameValue, state, baseValue_);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state, Object baseValue_) {
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return this.doI64(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_generic1(VirtualFrame frameValue, int state, Object baseValue_) {
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                if ((state & 1) != 0 && LLVMTypes.isNativePointer(offsetValue_)) {
                    LLVMNativePointer offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                    return this.doLLVMPointer(baseValue__, offsetValue__);
                }
                if ((state & 2) != 0 && offsetValue_ instanceof Long) {
                    long offsetValue__ = (Long)offsetValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private LLVMPointer executeAndSpecialize(Object baseValue, Object offsetValue) {
            int state = this.state_;
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                if (LLVMTypes.isNativePointer(offsetValue)) {
                    LLVMNativePointer offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                    this.state_ = state |= 1;
                    return this.doLLVMPointer(baseValue_, offsetValue_);
                }
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_ = state |= 2;
                    return this.doI64(baseValue_, offsetValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_, this.offset_}, new Object[]{baseValue, offsetValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressSegmentComputationNode create(LLVMExpressionNode base, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressSegmentComputationNodeGen(base, offset);
        }
    }

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode.class)
    public static final class LLVMAMD64AddressNoBaseOffsetComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode {
        @Node.Child
        private LLVMExpressionNode offset_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AddressNoBaseOffsetComputationNodeGen(int displacement, int shift, LLVMExpressionNode offset) {
            super(displacement, shift);
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doInt(offsetValue_);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            long offsetValue_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doLong(offsetValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if ((state & 1) != 0 && offsetValue_ instanceof Integer) {
                int offsetValue__ = (Integer)offsetValue_;
                return this.doInt(offsetValue__);
            }
            if ((state & 2) != 0 && offsetValue_ instanceof Long) {
                long offsetValue__ = (Long)offsetValue_;
                return this.doLong(offsetValue__);
            }
            if ((state & 4) != 0 && LLVMTypes.isNativePointer(offsetValue_)) {
                LLVMNativePointer offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                return this.doLLVMNativePointer(offsetValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(offsetValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long offsetValue_;
            int state = this.state_;
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 2) != 0) {
                return this.doLong(offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(offsetValue_));
        }

        private Object executeAndSpecialize(Object offsetValue) {
            int state = this.state_;
            if (offsetValue instanceof Integer) {
                int offsetValue_ = (Integer)offsetValue;
                this.state_ = state |= 1;
                return this.doInt(offsetValue_);
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (Long)offsetValue;
                this.state_ = state |= 2;
                return this.doLong(offsetValue_);
            }
            if (LLVMTypes.isNativePointer(offsetValue)) {
                LLVMNativePointer offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                this.state_ = state |= 4;
                return this.doLLVMNativePointer(offsetValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.offset_}, new Object[]{offsetValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressNoBaseOffsetComputationNode create(int displacement, int shift, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressNoBaseOffsetComputationNodeGen(displacement, shift, offset);
        }
    }

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode.class)
    public static final class LLVMAMD64AddressOffsetComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode {
        @Node.Child
        private LLVMExpressionNode base_;
        @Node.Child
        private LLVMExpressionNode offset_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AddressOffsetComputationNodeGen(int displacement, int shift, LLVMExpressionNode base, LLVMExpressionNode offset) {
            super(displacement, shift);
            this.base_ = base;
            this.offset_ = offset;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1E) == 0 && state != 0) {
                return this.executeGeneric_int_int0(frameValue, state);
            }
            if ((state & 0x1D) == 0 && state != 0) {
                return this.executeGeneric_long_int1(frameValue, state);
            }
            if ((state & 0x1B) == 0 && state != 0) {
                return this.executeGeneric_long_long2(frameValue, state);
            }
            if ((state & 0x17) == 0 && state != 0) {
                return this.executeGeneric_int3(frameValue, state);
            }
            if ((state & 0xF) == 0 && state != 0) {
                return this.executeGeneric_long4(frameValue, state);
            }
            return this.executeGeneric_generic5(frameValue, state);
        }

        private Object executeGeneric_int_int0(VirtualFrame frameValue, int state) {
            int offsetValue_;
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), offsetValue);
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long_int1(VirtualFrame frameValue, int state) {
            int offsetValue_;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), offsetValue);
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long_long2(VirtualFrame frameValue, int state) {
            long offsetValue_;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), offsetValue);
            }
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
            int offsetValue_;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            assert ((state & 8) != 0);
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return this.doLLVMPointer(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
            long offsetValue_;
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(baseValue_, ex.getResult());
            }
            assert ((state & 0x10) != 0);
            if (LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return this.doLLVMPointer(baseValue__, offsetValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        private Object executeGeneric_generic5(VirtualFrame frameValue, int state) {
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if ((state & 3) != 0 && offsetValue_ instanceof Integer) {
                int offsetValue__ = (Integer)offsetValue_;
                if ((state & 1) != 0 && baseValue_ instanceof Integer) {
                    int baseValue__ = (Integer)baseValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
                if ((state & 2) != 0 && baseValue_ instanceof Long) {
                    long baseValue__ = (Long)baseValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
            }
            if ((state & 4) != 0 && baseValue_ instanceof Long) {
                long baseValue__ = (Long)baseValue_;
                if (offsetValue_ instanceof Long) {
                    long offsetValue__ = (Long)offsetValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
            }
            if ((state & 0x18) != 0 && LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                if ((state & 8) != 0 && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (Integer)offsetValue_;
                    return this.doLLVMPointer(baseValue__, offsetValue__);
                }
                if ((state & 0x10) != 0 && offsetValue_ instanceof Long) {
                    long offsetValue__ = (Long)offsetValue_;
                    return this.doLLVMPointer(baseValue__, offsetValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, offsetValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 6) == 0 && (state & 7) != 0) {
                return this.executeI64_int_int6(frameValue, state);
            }
            if ((state & 5) == 0 && (state & 7) != 0) {
                return this.executeI64_long_int7(frameValue, state);
            }
            if ((state & 3) == 0 && (state & 7) != 0) {
                return this.executeI64_long_long8(frameValue, state);
            }
            return this.executeI64_generic9(frameValue, state);
        }

        private long executeI64_int_int6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            int offsetValue_;
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), offsetValue));
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, ex.getResult()));
            }
            assert ((state & 1) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private long executeI64_long_int7(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            int offsetValue_;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), offsetValue));
            }
            try {
                offsetValue_ = this.offset_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, ex.getResult()));
            }
            assert ((state & 2) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private long executeI64_long_long8(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            long offsetValue_;
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object offsetValue = this.offset_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult(), offsetValue));
            }
            try {
                offsetValue_ = this.offset_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, ex.getResult()));
            }
            assert ((state & 4) != 0);
            return this.doI64(baseValue_, offsetValue_);
        }

        private long executeI64_generic9(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            Object offsetValue_ = this.offset_.executeGeneric(frameValue);
            if ((state & 3) != 0 && offsetValue_ instanceof Integer) {
                int offsetValue__ = (Integer)offsetValue_;
                if ((state & 1) != 0 && baseValue_ instanceof Integer) {
                    int baseValue__ = (Integer)baseValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
                if ((state & 2) != 0 && baseValue_ instanceof Long) {
                    long baseValue__ = (Long)baseValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
            }
            if ((state & 4) != 0 && baseValue_ instanceof Long) {
                long baseValue__ = (Long)baseValue_;
                if (offsetValue_ instanceof Long) {
                    long offsetValue__ = (Long)offsetValue_;
                    return this.doI64(baseValue__, offsetValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_, offsetValue_));
        }

        private Object executeAndSpecialize(Object baseValue, Object offsetValue) {
            int state = this.state_;
            if (offsetValue instanceof Integer) {
                int offsetValue_ = (Integer)offsetValue;
                if (baseValue instanceof Integer) {
                    int baseValue_ = (Integer)baseValue;
                    this.state_ = state |= 1;
                    return this.doI64(baseValue_, offsetValue_);
                }
                if (baseValue instanceof Long) {
                    long baseValue_ = (Long)baseValue;
                    this.state_ = state |= 2;
                    return this.doI64(baseValue_, offsetValue_);
                }
            }
            if (baseValue instanceof Long) {
                long baseValue_ = (Long)baseValue;
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_ = state |= 4;
                    return this.doI64(baseValue_, offsetValue_);
                }
            }
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                if (offsetValue instanceof Integer) {
                    int offsetValue_ = (Integer)offsetValue;
                    this.state_ = state |= 8;
                    return this.doLLVMPointer(baseValue_, offsetValue_);
                }
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_ = state |= 0x10;
                    return this.doLLVMPointer(baseValue_, offsetValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_, this.offset_}, new Object[]{baseValue, offsetValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressOffsetComputationNode create(int displacement, int shift, LLVMExpressionNode base, LLVMExpressionNode offset) {
            return new LLVMAMD64AddressOffsetComputationNodeGen(displacement, shift, base, offset);
        }
    }

    @GeneratedBy(value=LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode.class)
    public static final class LLVMAMD64AddressDisplacementComputationNodeGen
    extends LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode {
        @Node.Child
        private LLVMExpressionNode base_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64AddressDisplacementComputationNodeGen(int displacement, LLVMExpressionNode base) {
            super(displacement);
            this.base_ = base;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 5) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 3) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doInt(baseValue_);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doLong(baseValue_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                return this.doLLVMPointer(baseValue__);
            }
            if ((state & 2) != 0 && baseValue_ instanceof Integer) {
                int baseValue__ = (Integer)baseValue_;
                return this.doInt(baseValue__);
            }
            if ((state & 4) != 0 && baseValue_ instanceof Long) {
                long baseValue__ = (Long)baseValue_;
                return this.doLong(baseValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 4) == 0 && (state & 6) != 0) {
                return this.executeI64_int3(frameValue, state);
            }
            if ((state & 2) == 0 && (state & 6) != 0) {
                return this.executeI64_long4(frameValue, state);
            }
            return this.executeI64_generic5(frameValue, state);
        }

        private long executeI64_int3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            int baseValue_;
            try {
                baseValue_ = this.base_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state & 2) != 0);
            return this.doInt(baseValue_);
        }

        private long executeI64_long4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            long baseValue_;
            try {
                baseValue_ = this.base_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state & 4) != 0);
            return this.doLong(baseValue_);
        }

        private long executeI64_generic5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
            Object baseValue_ = this.base_.executeGeneric(frameValue);
            if ((state & 2) != 0 && baseValue_ instanceof Integer) {
                int baseValue__ = (Integer)baseValue_;
                return this.doInt(baseValue__);
            }
            if ((state & 4) != 0 && baseValue_ instanceof Long) {
                long baseValue__ = (Long)baseValue_;
                return this.doLong(baseValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(baseValue_));
        }

        private Object executeAndSpecialize(Object baseValue) {
            int state = this.state_;
            if (LLVMTypes.isPointer(baseValue)) {
                LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
                this.state_ = state |= 1;
                return this.doLLVMPointer(baseValue_);
            }
            if (baseValue instanceof Integer) {
                int baseValue_ = (Integer)baseValue;
                this.state_ = state |= 2;
                return this.doInt(baseValue_);
            }
            if (baseValue instanceof Long) {
                long baseValue_ = (Long)baseValue;
                this.state_ = state |= 4;
                return this.doLong(baseValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.base_}, new Object[]{baseValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64AddressComputationNode.LLVMAMD64AddressDisplacementComputationNode create(int displacement, LLVMExpressionNode base) {
            return new LLVMAMD64AddressDisplacementComputationNodeGen(displacement, base);
        }
    }
}

