/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMAMD64RegisterToLongNode
extends LLVMNode {
    public abstract long execute(VirtualFrame var1, FrameSlot var2);

    @Specialization(guards={"isLong(frame, slot)"})
    protected long readLong(VirtualFrame frame, FrameSlot slot) {
        return FrameUtil.getLongSafe((Frame)frame, (FrameSlot)slot);
    }

    @Specialization(guards={"isAddress(frame, slot)"})
    protected long readAddress(VirtualFrame frame, FrameSlot slot) {
        return LLVMNativePointer.cast(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot)).asNative();
    }

    protected boolean isLong(VirtualFrame frame, FrameSlot slot) {
        return frame.getFrameDescriptor().getFrameSlotKind(slot) == FrameSlotKind.Long;
    }

    protected boolean isAddress(VirtualFrame frame, FrameSlot slot) {
        return frame.getFrameDescriptor().getFrameSlotKind(slot) == FrameSlotKind.Object;
    }
}

