/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LongDivision {
    @CompilerDirectives.TruffleBoundary
    public static Result divu128by64(long a1, long a0, long b) {
        if (a1 == 0L && a0 > 0L && b > 0L) {
            return new Result(a0 / b, a0 % b);
        }
        BigInteger x = LongDivision.u128(a1, a0);
        BigInteger y = LongDivision.u64(b);
        BigInteger[] result = x.divideAndRemainder(y);
        BigInteger q = result[0];
        BigInteger r = result[1];
        if (q.bitLength() > 64) {
            return Result.OVERFLOW;
        }
        return new Result(q.longValue(), r.longValue());
    }

    @CompilerDirectives.TruffleBoundary
    public static Result divs128by64(long a1, long a0, long b) {
        if (a1 == 0L && a0 > 0L) {
            return new Result(a0 / b, a0 % b);
        }
        BigInteger x = LongDivision.s128(a1, a0);
        BigInteger y = BigInteger.valueOf(b);
        BigInteger[] result = x.divideAndRemainder(y);
        BigInteger q = result[0];
        BigInteger r = result[1];
        if (q.bitCount() > 64) {
            return Result.OVERFLOW;
        }
        return new Result(q.longValue(), r.longValue());
    }

    private static BigInteger u64(long x) {
        byte[] bytes = new byte[9];
        ByteBuffer.wrap(bytes, 1, 8).order(ByteOrder.BIG_ENDIAN).putLong(x);
        return new BigInteger(bytes);
    }

    private static BigInteger u128(long h, long l) {
        byte[] bytes = new byte[17];
        ByteBuffer.wrap(bytes, 1, 16).order(ByteOrder.BIG_ENDIAN).putLong(h).putLong(l);
        return new BigInteger(bytes);
    }

    private static BigInteger s128(long h, long l) {
        byte[] bytes = new byte[16];
        ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).putLong(h).putLong(l);
        return new BigInteger(bytes);
    }

    @CompilerDirectives.ValueType
    public static class Result {
        private static final long INVALID = Long.MIN_VALUE;
        public static final Result OVERFLOW = new Result(Long.MIN_VALUE, Long.MIN_VALUE);
        public final long quotient;
        public final long remainder;

        Result(long quotient, long remainder) {
            this.quotient = quotient;
            this.remainder = remainder;
        }

        public boolean isInvalid() {
            return this.quotient == Long.MIN_VALUE && this.remainder == Long.MIN_VALUE;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result r = (Result)o;
            return r.quotient == this.quotient && r.remainder == this.remainder;
        }

        public int hashCode() {
            return (int)(this.quotient ^ this.remainder);
        }

        public String toString() {
            return "Result[q=" + this.quotient + ",r=" + this.remainder + "]";
        }
    }
}

