/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64SyscallNode.class)
public final class LLVMAMD64SyscallNodeGen
extends LLVMAMD64SyscallNode {
    @Node.Child
    private LLVMExpressionNode rax_;
    @Node.Child
    private LLVMExpressionNode rdi_;
    @Node.Child
    private LLVMExpressionNode rsi_;
    @Node.Child
    private LLVMExpressionNode rdx_;
    @Node.Child
    private LLVMExpressionNode r10_;
    @Node.Child
    private LLVMExpressionNode r8_;
    @Node.Child
    private LLVMExpressionNode r9_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private CachedSyscallData cachedSyscall_cache;

    private LLVMAMD64SyscallNodeGen(LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode rsi, LLVMExpressionNode rdx, LLVMExpressionNode r10, LLVMExpressionNode r8, LLVMExpressionNode r9) {
        this.rax_ = rax;
        this.rdi_ = rdi;
        this.rsi_ = rsi;
        this.rdx_ = rdx;
        this.r10_ = r10;
        this.r8_ = r8;
        this.r9_ = r9;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object executeGeneric(VirtualFrame frameValue) {
        long raxValue_;
        int state = this.state_;
        try {
            raxValue_ = this.rax_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rdiValue = this.rdi_.executeGeneric(frameValue);
            Object rsiValue = this.rsi_.executeGeneric(frameValue);
            Object rdxValue = this.rdx_.executeGeneric(frameValue);
            Object r10Value = this.r10_.executeGeneric(frameValue);
            Object r8Value = this.r8_.executeGeneric(frameValue);
            Object r9Value = this.r9_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rdiValue, rsiValue, rdxValue, r10Value, r8Value, r9Value);
        }
        Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
        Object rsiValue_ = this.rsi_.executeGeneric(frameValue);
        Object rdxValue_ = this.rdx_.executeGeneric(frameValue);
        Object r10Value_ = this.r10_.executeGeneric(frameValue);
        Object r8Value_ = this.r8_.executeGeneric(frameValue);
        Object r9Value_ = this.r9_.executeGeneric(frameValue);
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedSyscallData s1_ = this.cachedSyscall_cache;
                while (s1_ != null) {
                    if (raxValue_ == s1_.cachedRax_) {
                        return this.cachedSyscall(raxValue_, rdiValue_, rsiValue_, rdxValue_, r10Value_, r8Value_, r9Value_, s1_.cachedRax_, s1_.node_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return this.doI64(raxValue_, rdiValue_, rsiValue_, rdxValue_, r10Value_, r8Value_, r9Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(raxValue_, rdiValue_, rsiValue_, rdxValue_, r10Value_, r8Value_, r9Value_);
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public long executeI64(VirtualFrame frameValue) {
        long raxValue_;
        int state = this.state_;
        try {
            raxValue_ = this.rax_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rdiValue = this.rdi_.executeGeneric(frameValue);
            Object rsiValue = this.rsi_.executeGeneric(frameValue);
            Object rdxValue = this.rdx_.executeGeneric(frameValue);
            Object r10Value = this.r10_.executeGeneric(frameValue);
            Object r8Value = this.r8_.executeGeneric(frameValue);
            Object r9Value = this.r9_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rdiValue, rsiValue, rdxValue, r10Value, r8Value, r9Value);
        }
        Object rdiValue_ = this.rdi_.executeGeneric(frameValue);
        Object rsiValue_ = this.rsi_.executeGeneric(frameValue);
        Object rdxValue_ = this.rdx_.executeGeneric(frameValue);
        Object r10Value_ = this.r10_.executeGeneric(frameValue);
        Object r8Value_ = this.r8_.executeGeneric(frameValue);
        Object r9Value_ = this.r9_.executeGeneric(frameValue);
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedSyscallData s1_ = this.cachedSyscall_cache;
                while (s1_ != null) {
                    if (raxValue_ == s1_.cachedRax_) {
                        return this.cachedSyscall(raxValue_, rdiValue_, rsiValue_, rdxValue_, r10Value_, r8Value_, r9Value_, s1_.cachedRax_, s1_.node_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return this.doI64(raxValue_, rdiValue_, rsiValue_, rdxValue_, r10Value_, r8Value_, r9Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(raxValue_, rdiValue_, rsiValue_, rdxValue_, r10Value_, r8Value_, r9Value_);
    }

    private long executeAndSpecialize(Object raxValue, Object rdiValue, Object rsiValue, Object rdxValue, Object r10Value, Object r8Value, Object r9Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (raxValue instanceof Long) {
                long raxValue_ = (Long)raxValue;
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedSyscallData s1_ = this.cachedSyscall_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && raxValue_ != s1_.cachedRax_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 332) {
                        s1_ = (CachedSyscallData)super.insert((Node)new CachedSyscallData(this.cachedSyscall_cache));
                        s1_.cachedRax_ = raxValue_;
                        s1_.node_ = s1_.insertAccessor(this.createNode(raxValue_));
                        this.cachedSyscall_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long l = this.cachedSyscall(raxValue_, rdiValue, rsiValue, rdxValue, r10Value, r8Value, r9Value, s1_.cachedRax_, s1_.node_);
                        return l;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cachedSyscall_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                long l = this.doI64(raxValue_, rdiValue, rsiValue, rdxValue, r10Value, r8Value, r9Value);
                return l;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.rax_, this.rdi_, this.rsi_, this.rdx_, this.r10_, this.r8_, this.r9_}, new Object[]{raxValue, rdiValue, rsiValue, rdxValue, r10Value, r8Value, r9Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedSyscallData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cachedSyscall_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMAMD64SyscallNode create(LLVMExpressionNode rax, LLVMExpressionNode rdi, LLVMExpressionNode rsi, LLVMExpressionNode rdx, LLVMExpressionNode r10, LLVMExpressionNode r8, LLVMExpressionNode r9) {
        return new LLVMAMD64SyscallNodeGen(rax, rdi, rsi, rdx, r10, r8, r9);
    }

    @GeneratedBy(value=LLVMAMD64SyscallNode.class)
    private static final class CachedSyscallData
    extends Node {
        @Node.Child
        CachedSyscallData next_;
        @CompilerDirectives.CompilationFinal
        long cachedRax_;
        @Node.Child
        LLVMSyscallOperationNode node_;

        CachedSyscallData(CachedSyscallData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

