/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToAddressNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMToAddressNode.class)
public final class LLVMToAddressNodeGen
extends LLVMToAddressNode {
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMToAddressNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public Object executeWithTarget(Object fromNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && fromNodeValue instanceof Boolean) {
            boolean fromNodeValue_ = (Boolean)fromNodeValue;
            return this.doI1(fromNodeValue_);
        }
        if ((state & 2) != 0 && fromNodeValue instanceof Byte) {
            byte fromNodeValue_ = (Byte)fromNodeValue;
            return this.doI8(fromNodeValue_);
        }
        if ((state & 4) != 0 && fromNodeValue instanceof Short) {
            short fromNodeValue_ = (Short)fromNodeValue;
            return this.doI16(fromNodeValue_);
        }
        if ((state & 8) != 0 && fromNodeValue instanceof Integer) {
            int fromNodeValue_ = (Integer)fromNodeValue;
            return this.doI32(fromNodeValue_);
        }
        if ((state & 0x10) != 0 && fromNodeValue instanceof Long) {
            long fromNodeValue_ = (Long)fromNodeValue;
            return this.doI64(fromNodeValue_);
        }
        if ((state & 0x20) != 0 && LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            return this.doLLVMPointer(fromNodeValue_);
        }
        if ((state & 0x40) != 0 && fromNodeValue instanceof LLVMInteropType) {
            LLVMInteropType fromNodeValue_ = (LLVMInteropType)fromNodeValue;
            return this.doInteropType(fromNodeValue_);
        }
        if ((state & 0x80) != 0 && fromNodeValue instanceof String) {
            String fromNodeValue_ = (String)fromNodeValue;
            return this.doString(fromNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0xFE) == 0 && state != 0) {
            return this.executeGeneric_boolean0(frameValue, state);
        }
        if ((state & 0xFD) == 0 && state != 0) {
            return this.executeGeneric_byte1(frameValue, state);
        }
        if ((state & 0xFB) == 0 && state != 0) {
            return this.executeGeneric_short2(frameValue, state);
        }
        if ((state & 0xF7) == 0 && state != 0) {
            return this.executeGeneric_int3(frameValue, state);
        }
        if ((state & 0xEF) == 0 && state != 0) {
            return this.executeGeneric_long4(frameValue, state);
        }
        return this.executeGeneric_generic5(frameValue, state);
    }

    private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
        boolean fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doI1(fromNodeValue_);
    }

    private Object executeGeneric_byte1(VirtualFrame frameValue, int state) {
        byte fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 2) != 0);
        return this.doI8(fromNodeValue_);
    }

    private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
        short fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        return this.doI16(fromNodeValue_);
    }

    private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
        int fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 8) != 0);
        return this.doI32(fromNodeValue_);
    }

    private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
        long fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 0x10) != 0);
        return this.doI64(fromNodeValue_);
    }

    private Object executeGeneric_generic5(VirtualFrame frameValue, int state) {
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if ((state & 1) != 0 && fromNodeValue_ instanceof Boolean) {
            boolean fromNodeValue__ = (Boolean)fromNodeValue_;
            return this.doI1(fromNodeValue__);
        }
        if ((state & 2) != 0 && fromNodeValue_ instanceof Byte) {
            byte fromNodeValue__ = (Byte)fromNodeValue_;
            return this.doI8(fromNodeValue__);
        }
        if ((state & 4) != 0 && fromNodeValue_ instanceof Short) {
            short fromNodeValue__ = (Short)fromNodeValue_;
            return this.doI16(fromNodeValue__);
        }
        if ((state & 8) != 0 && fromNodeValue_ instanceof Integer) {
            int fromNodeValue__ = (Integer)fromNodeValue_;
            return this.doI32(fromNodeValue__);
        }
        if ((state & 0x10) != 0 && fromNodeValue_ instanceof Long) {
            long fromNodeValue__ = (Long)fromNodeValue_;
            return this.doI64(fromNodeValue__);
        }
        if ((state & 0x20) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doLLVMPointer(fromNodeValue__);
        }
        if ((state & 0x40) != 0 && fromNodeValue_ instanceof LLVMInteropType) {
            LLVMInteropType fromNodeValue__ = (LLVMInteropType)fromNodeValue_;
            return this.doInteropType(fromNodeValue__);
        }
        if ((state & 0x80) != 0 && fromNodeValue_ instanceof String) {
            String fromNodeValue__ = (String)fromNodeValue_;
            return this.doString(fromNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private Object executeAndSpecialize(Object fromNodeValue) {
        int state = this.state_;
        if (fromNodeValue instanceof Boolean) {
            boolean fromNodeValue_ = (Boolean)fromNodeValue;
            this.state_ = state |= 1;
            return this.doI1(fromNodeValue_);
        }
        if (fromNodeValue instanceof Byte) {
            byte fromNodeValue_ = (Byte)fromNodeValue;
            this.state_ = state |= 2;
            return this.doI8(fromNodeValue_);
        }
        if (fromNodeValue instanceof Short) {
            short fromNodeValue_ = (Short)fromNodeValue;
            this.state_ = state |= 4;
            return this.doI16(fromNodeValue_);
        }
        if (fromNodeValue instanceof Integer) {
            int fromNodeValue_ = (Integer)fromNodeValue;
            this.state_ = state |= 8;
            return this.doI32(fromNodeValue_);
        }
        if (fromNodeValue instanceof Long) {
            long fromNodeValue_ = (Long)fromNodeValue;
            this.state_ = state |= 0x10;
            return this.doI64(fromNodeValue_);
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            this.state_ = state |= 0x20;
            return this.doLLVMPointer(fromNodeValue_);
        }
        if (fromNodeValue instanceof LLVMInteropType) {
            LLVMInteropType fromNodeValue_ = (LLVMInteropType)fromNodeValue;
            this.state_ = state |= 0x40;
            return this.doInteropType(fromNodeValue_);
        }
        if (fromNodeValue instanceof String) {
            String fromNodeValue_ = (String)fromNodeValue;
            this.state_ = state |= 0x80;
            return this.doString(fromNodeValue_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMToAddressNode create(LLVMExpressionNode fromNode) {
        return new LLVMToAddressNodeGen(fromNode);
    }
}

