/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeField(name="index", type=int.class)
public abstract class LLVMArgNode
extends LLVMExpressionNode {
    public abstract int getIndex();

    @Specialization(guards={"isPointer(frame)"})
    protected Object doPointer(VirtualFrame frame) {
        return LLVMPointer.cast(frame.getArguments()[this.getIndex()]).copy();
    }

    public boolean isPointer(VirtualFrame frame) {
        return LLVMPointer.isInstance(frame.getArguments()[this.getIndex()]);
    }

    @Specialization(guards={"!isPointer(frame)"})
    protected Object doObject(VirtualFrame frame) {
        return frame.getArguments()[this.getIndex()];
    }
}

