/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeCallUtils;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;

public abstract class LLVMDispatchNode
extends LLVMNode {
    protected static final int INLINE_CACHE_SIZE = 5;
    protected final FunctionType type;
    @CompilerDirectives.CompilationFinal
    private String signature;

    protected LLVMDispatchNode(FunctionType type) {
        this.type = type;
    }

    private String getSignature() {
        if (this.signature == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            try {
                NFIContextExtension nfiContextExtension = LLVMLanguage.getLanguage().getContextExtension(NFIContextExtension.class);
                this.signature = nfiContextExtension.getNativeSignature(this.type, 1);
            }
            catch (NFIContextExtension.UnsupportedNativeTypeException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)ex);
            }
        }
        return this.signature;
    }

    public abstract Object executeDispatch(Object var1, Object[] var2);

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"function == cachedFunction", "cachedFunction.isLLVMIRFunction()"})
    protected static Object doDirect(LLVMFunctionDescriptor function, Object[] arguments, @Cached(value="function") LLVMFunctionDescriptor cachedFunction, @Cached(value="create(cachedFunction.getLLVMIRFunctionSlowPath())") DirectCallNode callNode) {
        try (LLVMStack.StackPointer sp = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            Object object = callNode.call(arguments);
            return object;
        }
    }

    @Specialization(replaces={"doDirect"}, guards={"descriptor.isLLVMIRFunction()"})
    protected static Object doIndirect(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached LLVMFunctionDescriptor.ResolveFunctionNode resolve, @Cached(value="create()") IndirectCallNode callNode) {
        try (LLVMStack.StackPointer sp = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            Object object = callNode.call((CallTarget)descriptor.getLLVMIRFunction(resolve), arguments);
            return object;
        }
    }

    protected DirectCallNode getIntrinsificationCallNode(LLVMFunctionDescriptor.Intrinsic intrinsic) {
        RootCallTarget target = intrinsic.cachedCallTarget(this.type);
        DirectCallNode directCallNode = DirectCallNode.create((CallTarget)target);
        return directCallNode;
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"function == cachedFunction", "cachedFunction.isIntrinsicFunctionSlowPath()"})
    protected Object doDirectIntrinsic(LLVMFunctionDescriptor function, Object[] arguments, @Cached(value="function") LLVMFunctionDescriptor cachedFunction, @Cached(value="getIntrinsificationCallNode(cachedFunction.getIntrinsicSlowPath())") DirectCallNode callNode) {
        try (LLVMStack.StackPointer sp = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            Object object = callNode.call(arguments);
            return object;
        }
    }

    @Specialization(replaces={"doDirectIntrinsic"}, guards={"descriptor.isIntrinsicFunction(resolve)"})
    protected Object doIndirectIntrinsic(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached LLVMFunctionDescriptor.ResolveFunctionNode resolve, @Cached(value="create()") IndirectCallNode callNode) {
        try (LLVMStack.StackPointer sp = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            Object object = callNode.call((CallTarget)descriptor.getIntrinsic(resolve).cachedCallTarget(this.type), arguments);
            return object;
        }
    }

    @Specialization(limit="10", guards={"descriptor == cachedDescriptor", "cachedDescriptor.isNativeFunctionSlowPath()"})
    protected Object doCachedNative(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor") LLVMFunctionDescriptor cachedDescriptor, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @Cached(value="bindSymbol(cachedDescriptor)") Object cachedBoundFunction, @CachedLibrary(value="cachedBoundFunction") InteropLibrary nativeCall, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object returnValue;
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        try (LLVMStack.StackPointer save = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, cachedBoundFunction, nativeArgs, cachedDescriptor);
        }
        return fromNative.executeConvert(returnValue);
    }

    protected Object bindSymbol(LLVMFunctionDescriptor descriptor) {
        CompilerAsserts.neverPartOfCompilation();
        assert (descriptor.getNativeFunctionSlowPath() != null) : descriptor.getName();
        return LLVMNativeCallUtils.bindNativeSymbol((InteropLibrary)InteropLibrary.getFactory().getUncached(), descriptor.getNativeFunctionSlowPath(), this.getSignature());
    }

    @Specialization(replaces={"doCachedNative"}, guards={"descriptor.isNativeFunction(resolve)"})
    protected Object doNative(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @CachedLibrary(limit="3") InteropLibrary nativeCall, @CachedLibrary(limit="3") InteropLibrary bind, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached LLVMFunctionDescriptor.ResolveFunctionNode resolve, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object returnValue;
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        Object boundSymbol = LLVMNativeCallUtils.bindNativeSymbol(bind, descriptor.getNativeFunction(resolve), this.getSignature());
        try (LLVMStack.StackPointer save = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
            returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, boundSymbol, nativeArgs, descriptor);
        }
        return fromNative.executeConvert(returnValue);
    }

    @ExplodeLoop
    private static Object[] prepareNativeArguments(Object[] arguments, LLVMNativeConvertNode[] toNative) {
        Object[] nativeArgs = new Object[arguments.length - 1];
        for (int i = 1; i < arguments.length; ++i) {
            nativeArgs[i - 1] = toNative[i - 1].executeConvert(arguments[i]);
        }
        return nativeArgs;
    }

    @ExplodeLoop
    protected LLVMNativeConvertNode[] createToNativeNodes() {
        LLVMNativeConvertNode[] ret = new LLVMNativeConvertNode[this.type.getArgumentTypes().length - 1];
        for (int i = 1; i < this.type.getArgumentTypes().length; ++i) {
            ret[i - 1] = LLVMNativeConvertNode.createToNative(this.type.getArgumentTypes()[i]);
        }
        return ret;
    }

    protected LLVMNativeConvertNode createFromNativeNode() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMNativeConvertNode.createFromNative(this.type.getReturnType());
    }

    @Specialization
    protected Object doForeign(LLVMTypedForeignObject foreign, Object[] arguments, @Cached(value="create(type)") LLVMLookupDispatchForeignNode lookupDispatchForeignNode) {
        return lookupDispatchForeignNode.execute(foreign.getForeign(), foreign.getType(), arguments);
    }

    @Specialization
    protected static Object doNativeFunction(LLVMNativePointer pointer, Object[] arguments, @Cached(value="createCachedNativeDispatch()") LLVMNativeDispatchNode dispatchNode) {
        return dispatchNode.executeDispatch(pointer, arguments);
    }

    protected LLVMDispatchNode createCachedDispatch() {
        return LLVMDispatchNodeGen.create(this.type);
    }

    protected LLVMNativeDispatchNode createCachedNativeDispatch() {
        return LLVMNativeDispatchNodeGen.create(this.type);
    }

    static abstract class LLVMLookupDispatchForeignNode
    extends LLVMNode {
        private final FunctionType type;

        LLVMLookupDispatchForeignNode(FunctionType type) {
            this.type = type;
        }

        abstract Object execute(Object var1, LLVMInteropType.Structured var2, Object[] var3);

        @Specialization(guards={"functionType == cachedType"}, limit="5")
        protected Object doCachedType(TruffleObject function, LLVMInteropType.Function functionType, Object[] arguments, @Cached(value="functionType") LLVMInteropType.Function cachedType, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode) {
            return this.doGeneric(function, cachedType, arguments, crossLanguageCall, dataEscapeNodes, toLLVMNode);
        }

        @Specialization(replaces={"doCachedType"}, limit="0")
        protected Object doGeneric(TruffleObject function, LLVMInteropType.Function functionType, Object[] arguments, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode) {
            try {
                Object ret;
                Object[] args = this.getForeignArguments(dataEscapeNodes, arguments, functionType);
                try (LLVMStack.StackPointer save = ((LLVMStack.StackPointer)arguments[0]).newFrame();){
                    ret = crossLanguageCall.execute((Object)function, args);
                }
                if (!(this.type.getReturnType() instanceof VoidType) && functionType != null) {
                    LLVMInteropType retType = functionType.getReturnType();
                    if (retType instanceof LLVMInteropType.Value) {
                        return toLLVMNode.executeWithType(ret, ((LLVMInteropType.Value)retType).getBaseType());
                    }
                    CompilerDirectives.transferToInterpreter();
                    throw new LLVMPolyglotException(this, "Can not call polyglot function with structured return type.");
                }
                return toLLVMNode.executeWithTarget(ret);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Specialization(guards={"functionType == null"}, limit="5")
        protected Object doUnknownType(TruffleObject function, LLVMInteropType.Structured functionType, Object[] arguments, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode) {
            return this.doGeneric(function, null, arguments, crossLanguageCall, dataEscapeNodes, toLLVMNode);
        }

        @ExplodeLoop
        private Object[] getForeignArguments(LLVMDataEscapeNode[] dataEscapeNodes, Object[] arguments, LLVMInteropType.Function functionType) {
            int i;
            assert (arguments.length == this.type.getArgumentTypes().length);
            Object[] args = new Object[dataEscapeNodes.length];
            if (functionType != null) {
                assert (arguments.length == functionType.getParameterLength() + 1);
                for (i = 0; i < functionType.getParameterLength(); ++i) {
                    LLVMInteropType argType = functionType.getParameter(i);
                    if (!(argType instanceof LLVMInteropType.Value)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new LLVMPolyglotException(this, "Can not call polyglot function with structured argument type.");
                    }
                    LLVMInteropType.Structured baseType = ((LLVMInteropType.Value)argType).getBaseType();
                    args[i] = dataEscapeNodes[i].executeWithType(arguments[i + 1], baseType);
                }
            }
            while (i < args.length) {
                args[i] = dataEscapeNodes[i].executeWithTarget(arguments[i + 1]);
                ++i;
            }
            return args;
        }

        protected ForeignToLLVM createToLLVMNode() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.convert(this.type.getReturnType()));
        }

        @CompilerDirectives.TruffleBoundary
        protected LLVMDataEscapeNode[] createLLVMDataEscapeNodes() {
            Type[] argTypes = this.type.getArgumentTypes();
            LLVMDataEscapeNode[] args = new LLVMDataEscapeNode[argTypes.length - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = LLVMDataEscapeNode.create(argTypes[i + 1]);
            }
            return args;
        }

        public static LLVMLookupDispatchForeignNode create(FunctionType type) {
            return LLVMDispatchNodeGen.LLVMLookupDispatchForeignNodeGen.create(type);
        }
    }
}

