/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptorFactory;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDispatchNode.class)
public final class LLVMDispatchNodeGen
extends LLVMDispatchNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
    @Node.Child
    private DirectData direct_cache;
    @Node.Child
    private LLVMFunctionDescriptor.ResolveFunctionNode indirect_resolve_;
    @Node.Child
    private IndirectCallNode indirect_callNode_;
    @Node.Child
    private DirectIntrinsicData directIntrinsic_cache;
    @Node.Child
    private IndirectIntrinsicData indirectIntrinsic_cache;
    @Node.Child
    private CachedNativeData cachedNative_cache;
    @Node.Child
    private NativeData native_cache;
    @Node.Child
    private LLVMDispatchNode.LLVMLookupDispatchForeignNode foreign_lookupDispatchForeignNode_;
    @Node.Child
    private LLVMNativeDispatchNode nativeFunction_dispatchNode_;

    private LLVMDispatchNodeGen(FunctionType type) {
        super(type);
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object executeDispatch(Object arg0Value, Object[] arg1Value) {
        int state = this.state_;
        if (state != 0) {
            TruffleObject arg0Value_;
            if ((state & 0x3F) != 0 && arg0Value instanceof LLVMFunctionDescriptor) {
                arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
                if ((state & 1) != 0) {
                    DirectData s1_ = this.direct_cache;
                    while (s1_ != null) {
                        if (arg0Value_ == s1_.cachedFunction_) {
                            assert (s1_.cachedFunction_.isLLVMIRFunction());
                            return LLVMDispatchNode.doDirect((LLVMFunctionDescriptor)arg0Value_, arg1Value, s1_.cachedFunction_, s1_.callNode_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0 && arg0Value_.isLLVMIRFunction()) {
                    return LLVMDispatchNode.doIndirect((LLVMFunctionDescriptor)arg0Value_, arg1Value, this.indirect_resolve_, this.indirect_callNode_);
                }
                if ((state & 4) != 0) {
                    DirectIntrinsicData s3_ = this.directIntrinsic_cache;
                    while (s3_ != null) {
                        if (arg0Value_ == s3_.cachedFunction_) {
                            assert (s3_.cachedFunction_.isIntrinsicFunctionSlowPath());
                            return this.doDirectIntrinsic((LLVMFunctionDescriptor)arg0Value_, arg1Value, s3_.cachedFunction_, s3_.callNode_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    IndirectIntrinsicData s4_ = this.indirectIntrinsic_cache;
                    while (s4_ != null) {
                        if (arg0Value_.isIntrinsicFunction(s4_.resolve_)) {
                            return this.doIndirectIntrinsic((LLVMFunctionDescriptor)arg0Value_, arg1Value, s4_.resolve_, s4_.callNode_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0x10) != 0) {
                    CachedNativeData s5_ = this.cachedNative_cache;
                    while (s5_ != null) {
                        assert (s5_.nativeCall_.accepts(s5_.cachedBoundFunction_));
                        if (arg0Value_ == s5_.cachedDescriptor_) {
                            assert (s5_.cachedDescriptor_.isNativeFunctionSlowPath());
                            return this.doCachedNative((LLVMFunctionDescriptor)arg0Value_, arg1Value, s5_.cachedDescriptor_, s5_.toNative_, s5_.fromNative_, s5_.cachedBoundFunction_, s5_.nativeCall_, this.lLVMLanguageContextReference_, s5_.statistics_);
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state & 0x20) != 0) {
                    NativeData s6_ = this.native_cache;
                    while (s6_ != null) {
                        if (arg0Value_.isNativeFunction(s6_.resolve_)) {
                            return this.doNative((LLVMFunctionDescriptor)arg0Value_, arg1Value, s6_.toNative_, s6_.fromNative_, s6_.nativeCall_, s6_.bind_, this.lLVMLanguageContextReference_, s6_.resolve_, s6_.statistics_);
                        }
                        s6_ = s6_.next_;
                    }
                }
            }
            if ((state & 0x40) != 0 && arg0Value instanceof LLVMTypedForeignObject) {
                arg0Value_ = (LLVMTypedForeignObject)arg0Value;
                return this.doForeign((LLVMTypedForeignObject)arg0Value_, arg1Value, this.foreign_lookupDispatchForeignNode_);
            }
            if ((state & 0x80) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                return LLVMDispatchNode.doNativeFunction((LLVMNativePointer)arg0Value_, arg1Value, this.nativeFunction_dispatchNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(Object arg0Value, Object[] arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            TruffleObject arg0Value_;
            if (arg0Value instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor.ResolveFunctionNode resolve__;
                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__;
                Object resolve__2;
                Object cachedFunction__;
                arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    DirectData s1_ = this.direct_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (arg0Value_ == s1_.cachedFunction_) {
                                assert (s1_.cachedFunction_.isLLVMIRFunction());
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && ((LLVMFunctionDescriptor)(cachedFunction__ = arg0Value_)).isLLVMIRFunction() && count1_ < 5) {
                        s1_ = (DirectData)super.insert((Node)new DirectData(this.direct_cache));
                        s1_.cachedFunction_ = cachedFunction__;
                        s1_.callNode_ = s1_.insertAccessor(DirectCallNode.create((CallTarget)((LLVMFunctionDescriptor)cachedFunction__).getLLVMIRFunctionSlowPath()));
                        this.direct_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedFunction__ = LLVMDispatchNode.doDirect((LLVMFunctionDescriptor)arg0Value_, arg1Value, s1_.cachedFunction_, s1_.callNode_);
                        return cachedFunction__;
                    }
                }
                if (arg0Value_.isLLVMIRFunction()) {
                    this.indirect_resolve_ = (LLVMFunctionDescriptor.ResolveFunctionNode)super.insert((Node)LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.create());
                    this.indirect_callNode_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.exclude_ = exclude |= 1;
                    this.direct_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object count1_ = LLVMDispatchNode.doIndirect((LLVMFunctionDescriptor)arg0Value_, arg1Value, this.indirect_resolve_, this.indirect_callNode_);
                    return count1_;
                }
                if ((exclude & 2) == 0) {
                    int count3_ = 0;
                    DirectIntrinsicData s3_ = this.directIntrinsic_cache;
                    if ((state & 4) != 0) {
                        while (s3_ != null) {
                            if (arg0Value_ == s3_.cachedFunction_) {
                                assert (s3_.cachedFunction_.isIntrinsicFunctionSlowPath());
                                break;
                            }
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && ((LLVMFunctionDescriptor)(cachedFunction__ = arg0Value_)).isIntrinsicFunctionSlowPath() && count3_ < 5) {
                        s3_ = (DirectIntrinsicData)super.insert((Node)new DirectIntrinsicData(this.directIntrinsic_cache));
                        s3_.cachedFunction_ = cachedFunction__;
                        s3_.callNode_ = s3_.insertAccessor(this.getIntrinsificationCallNode(((LLVMFunctionDescriptor)cachedFunction__).getIntrinsicSlowPath()));
                        this.directIntrinsic_cache = s3_;
                        this.state_ = state |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedFunction__ = this.doDirectIntrinsic((LLVMFunctionDescriptor)arg0Value_, arg1Value, s3_.cachedFunction_, s3_.callNode_);
                        return cachedFunction__;
                    }
                }
                int count4_ = 0;
                IndirectIntrinsicData s4_ = this.indirectIntrinsic_cache;
                if ((state & 8) != 0) {
                    while (s4_ != null && !arg0Value_.isIntrinsicFunction(s4_.resolve_)) {
                        s4_ = s4_.next_;
                        ++count4_;
                    }
                }
                if (s4_ == null && arg0Value_.isIntrinsicFunction((LLVMFunctionDescriptor.ResolveFunctionNode)((Object)(resolve__2 = (LLVMFunctionDescriptor.ResolveFunctionNode)super.insert((Node)LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.create())))) && count4_ < 3) {
                    s4_ = (IndirectIntrinsicData)super.insert((Node)new IndirectIntrinsicData(this.indirectIntrinsic_cache));
                    s4_.resolve_ = s4_.insertAccessor(resolve__2);
                    s4_.callNode_ = s4_.insertAccessor(IndirectCallNode.create());
                    this.indirectIntrinsic_cache = s4_;
                    this.exclude_ = exclude |= 2;
                    this.directIntrinsic_cache = null;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                }
                if (s4_ != null) {
                    lock.unlock();
                    hasLock = false;
                    resolve__2 = this.doIndirectIntrinsic((LLVMFunctionDescriptor)arg0Value_, arg1Value, s4_.resolve_, s4_.callNode_);
                    return resolve__2;
                }
                if ((exclude & 4) == 0) {
                    Object cachedDescriptor__;
                    int count5_ = 0;
                    CachedNativeData s5_ = this.cachedNative_cache;
                    if ((state & 0x10) != 0) {
                        while (s5_ != null) {
                            assert (s5_.nativeCall_.accepts(s5_.cachedBoundFunction_));
                            if (arg0Value_ == s5_.cachedDescriptor_) {
                                assert (s5_.cachedDescriptor_.isNativeFunctionSlowPath());
                                break;
                            }
                            s5_ = s5_.next_;
                            ++count5_;
                        }
                    }
                    if (s5_ == null && (cachedDescriptor__ = arg0Value_).isNativeFunctionSlowPath() && count5_ < 10) {
                        s5_ = (CachedNativeData)super.insert((Node)new CachedNativeData(this.cachedNative_cache));
                        s5_.cachedDescriptor_ = cachedDescriptor__;
                        s5_.toNative_ = s5_.insertAccessor(this.createToNativeNodes());
                        s5_.fromNative_ = s5_.insertAccessor(this.createFromNativeNode());
                        s5_.cachedBoundFunction_ = this.bindSymbol((LLVMFunctionDescriptor)cachedDescriptor__);
                        s5_.nativeCall_ = (InteropLibrary)s5_.insertAccessor(INTEROP_LIBRARY_.create(s5_.cachedBoundFunction_));
                        lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                        if (lLVMLanguageContextReference__ == null) {
                            this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                        }
                        s5_.statistics_ = LLVMNode.nativeCallStatisticsEnabled(lLVMLanguageContextReference__);
                        this.cachedNative_cache = s5_;
                        this.state_ = state |= 0x10;
                    }
                    if (s5_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedDescriptor__ = this.doCachedNative((LLVMFunctionDescriptor)arg0Value_, arg1Value, s5_.cachedDescriptor_, s5_.toNative_, s5_.fromNative_, s5_.cachedBoundFunction_, s5_.nativeCall_, this.lLVMLanguageContextReference_, s5_.statistics_);
                        return cachedDescriptor__;
                    }
                }
                int count6_ = 0;
                NativeData s6_ = this.native_cache;
                if ((state & 0x20) != 0) {
                    while (s6_ != null && !arg0Value_.isNativeFunction(s6_.resolve_)) {
                        s6_ = s6_.next_;
                        ++count6_;
                    }
                }
                if (s6_ == null && arg0Value_.isNativeFunction(resolve__ = (LLVMFunctionDescriptor.ResolveFunctionNode)super.insert((Node)LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.create())) && count6_ < 3) {
                    s6_ = (NativeData)super.insert((Node)new NativeData(this.native_cache));
                    s6_.toNative_ = s6_.insertAccessor(this.createToNativeNodes());
                    s6_.fromNative_ = s6_.insertAccessor(this.createFromNativeNode());
                    s6_.nativeCall_ = (InteropLibrary)s6_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                    s6_.bind_ = (InteropLibrary)s6_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                    lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__ == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    s6_.resolve_ = s6_.insertAccessor(resolve__);
                    s6_.statistics_ = LLVMNode.nativeCallStatisticsEnabled(lLVMLanguageContextReference__);
                    this.native_cache = s6_;
                    this.exclude_ = exclude |= 4;
                    this.cachedNative_cache = null;
                    state &= 0xFFFFFFEF;
                    this.state_ = state |= 0x20;
                }
                if (s6_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doNative((LLVMFunctionDescriptor)arg0Value_, arg1Value, s6_.toNative_, s6_.fromNative_, s6_.nativeCall_, s6_.bind_, this.lLVMLanguageContextReference_, s6_.resolve_, s6_.statistics_);
                    return object;
                }
            }
            if (arg0Value instanceof LLVMTypedForeignObject) {
                arg0Value_ = (LLVMTypedForeignObject)arg0Value;
                this.foreign_lookupDispatchForeignNode_ = (LLVMDispatchNode.LLVMLookupDispatchForeignNode)super.insert((Node)LLVMDispatchNode.LLVMLookupDispatchForeignNode.create(this.type));
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Object object = this.doForeign((LLVMTypedForeignObject)arg0Value_, arg1Value, this.foreign_lookupDispatchForeignNode_);
                return object;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                this.nativeFunction_dispatchNode_ = (LLVMNativeDispatchNode)super.insert((Node)this.createCachedNativeDispatch());
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Object object = LLVMDispatchNode.doNativeFunction((LLVMNativePointer)arg0Value_, arg1Value, this.nativeFunction_dispatchNode_);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            DirectData s1_ = this.direct_cache;
            DirectIntrinsicData s3_ = this.directIntrinsic_cache;
            IndirectIntrinsicData s4_ = this.indirectIntrinsic_cache;
            CachedNativeData s5_ = this.cachedNative_cache;
            NativeData s6_ = this.native_cache;
            if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null || s4_ != null && s4_.next_ != null || s5_ != null && s5_.next_ != null || s6_ != null && s6_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMDispatchNode create(FunctionType type) {
        return new LLVMDispatchNodeGen(type);
    }

    @GeneratedBy(value=LLVMDispatchNode.LLVMLookupDispatchForeignNode.class)
    static final class LLVMLookupDispatchForeignNodeGen
    extends LLVMDispatchNode.LLVMLookupDispatchForeignNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private CachedType0Data cachedType0_cache;
        @Node.Child
        private CachedType1Data cachedType1_cache;
        @Node.Child
        private Generic0Data generic0_cache;
        @Node.Child
        private Generic1Data generic1_cache;
        @Node.Child
        private UnknownType0Data unknownType0_cache;
        @Node.Child
        private UnknownType1Data unknownType1_cache;

        private LLVMLookupDispatchForeignNodeGen(FunctionType type) {
            super(type);
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        Object execute(Object arg0Value, LLVMInteropType.Structured arg1Value, Object[] arg2Value) {
            int state = this.state_;
            if (state != 0 && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject)arg0Value;
                if ((state & 0xF) != 0 && arg1Value instanceof LLVMInteropType.Function) {
                    Generic1Data s4_;
                    Generic0Data s3_;
                    LLVMInteropType.Function arg1Value_ = (LLVMInteropType.Function)arg1Value;
                    if ((state & 1) != 0) {
                        CachedType0Data s1_ = this.cachedType0_cache;
                        while (s1_ != null) {
                            if (s1_.crossLanguageCall_.accepts((Object)arg0Value_) && arg1Value_ == s1_.cachedType_) {
                                return this.doCachedType(arg0Value_, arg1Value_, arg2Value, s1_.cachedType_, s1_.crossLanguageCall_, s1_.dataEscapeNodes_, s1_.toLLVMNode_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        CachedType1Data s2_ = this.cachedType1_cache;
                        while (s2_ != null) {
                            if (arg1Value_ == s2_.cachedType_) {
                                return this.cachedType1Boundary(state, s2_, arg0Value_, arg1Value_, arg2Value);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 4) != 0 && (s3_ = this.generic0_cache) != null && s3_.crossLanguageCall_.accepts((Object)arg0Value_)) {
                        return this.doGeneric(arg0Value_, arg1Value_, arg2Value, s3_.crossLanguageCall_, s3_.dataEscapeNodes_, s3_.toLLVMNode_);
                    }
                    if ((state & 8) != 0 && (s4_ = this.generic1_cache) != null) {
                        return this.generic1Boundary(state, s4_, arg0Value_, arg1Value_, arg2Value);
                    }
                }
                if ((state & 0x30) != 0) {
                    UnknownType1Data s6_;
                    if ((state & 0x10) != 0) {
                        UnknownType0Data s5_ = this.unknownType0_cache;
                        while (s5_ != null) {
                            if (s5_.crossLanguageCall_.accepts((Object)arg0Value_) && arg1Value == null) {
                                return this.doUnknownType(arg0Value_, arg1Value, arg2Value, s5_.crossLanguageCall_, s5_.dataEscapeNodes_, s5_.toLLVMNode_);
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state & 0x20) != 0 && (s6_ = this.unknownType1_cache) != null && arg1Value == null) {
                        return this.unknownType1Boundary(state, s6_, arg0Value_, arg1Value, arg2Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object cachedType1Boundary(int state, CachedType1Data s2_, TruffleObject arg0Value_, LLVMInteropType.Function arg1Value_, Object[] arg2Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Object object = this.doCachedType(arg0Value_, arg1Value_, arg2Value, s2_.cachedType_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), s2_.dataEscapeNodes_, s2_.toLLVMNode_);
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object generic1Boundary(int state, Generic1Data s4_, TruffleObject arg0Value_, LLVMInteropType.Function arg1Value_, Object[] arg2Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Object object = this.doGeneric(arg0Value_, arg1Value_, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), s4_.dataEscapeNodes_, s4_.toLLVMNode_);
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object unknownType1Boundary(int state, UnknownType1Data s6_, TruffleObject arg0Value_, LLVMInteropType.Structured arg1Value, Object[] arg2Value) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Object object = this.doUnknownType(arg0Value_, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), s6_.dataEscapeNodes_, s6_.toLLVMNode_);
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value, Object[] arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                TruffleObject arg0Value_;
                block40: {
                    UnknownType0Data s5_;
                    int count5_;
                    block41: {
                        block42: {
                            Object object;
                            LLVMInteropType.Function arg1Value_;
                            block37: {
                                CachedType0Data s1_;
                                int count1_;
                                block38: {
                                    block39: {
                                        block36: {
                                            if (!(arg0Value instanceof TruffleObject)) throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                                            arg0Value_ = (TruffleObject)arg0Value;
                                            if (!(arg1Value instanceof LLVMInteropType.Function)) break block36;
                                            arg1Value_ = (LLVMInteropType.Function)arg1Value;
                                            if ((exclude & 1) != 0) break block37;
                                            count1_ = 0;
                                            s1_ = this.cachedType0_cache;
                                            if ((state & 1) == 0) break block38;
                                            break block39;
                                        }
                                        if ((exclude & 8) != 0) break block40;
                                        count5_ = 0;
                                        s5_ = this.unknownType0_cache;
                                        if ((state & 0x10) == 0) break block41;
                                        break block42;
                                    }
                                    while (!(s1_ == null || s1_.crossLanguageCall_.accepts((Object)arg0Value_) && arg1Value_ == s1_.cachedType_)) {
                                        s1_ = s1_.next_;
                                        ++count1_;
                                    }
                                }
                                if (s1_ == null && count1_ < 5) {
                                    s1_ = (CachedType0Data)super.insert((Node)new CachedType0Data(this.cachedType0_cache));
                                    s1_.cachedType_ = arg1Value_;
                                    s1_.crossLanguageCall_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create((Object)arg0Value_));
                                    s1_.dataEscapeNodes_ = s1_.insertAccessor(this.createLLVMDataEscapeNodes());
                                    s1_.toLLVMNode_ = s1_.insertAccessor(this.createToLLVMNode());
                                    this.cachedType0_cache = s1_;
                                    this.state_ = state |= 1;
                                }
                                if (s1_ != null) {
                                    lock.unlock();
                                    hasLock = false;
                                    Object object2 = this.doCachedType(arg0Value_, arg1Value_, arg2Value, s1_.cachedType_, s1_.crossLanguageCall_, s1_.dataEscapeNodes_, s1_.toLLVMNode_);
                                    return object2;
                                }
                            }
                            if ((exclude & 2) == 0) {
                                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                                try {
                                    int count2_ = 0;
                                    CachedType1Data s2_ = this.cachedType1_cache;
                                    if ((state & 2) != 0) {
                                        while (s2_ != null && arg1Value_ != s2_.cachedType_) {
                                            s2_ = s2_.next_;
                                            ++count2_;
                                        }
                                    }
                                    if (s2_ == null && count2_ < 5) {
                                        s2_ = (CachedType1Data)super.insert((Node)new CachedType1Data(this.cachedType1_cache));
                                        s2_.cachedType_ = arg1Value_;
                                        s2_.dataEscapeNodes_ = s2_.insertAccessor(this.createLLVMDataEscapeNodes());
                                        s2_.toLLVMNode_ = s2_.insertAccessor(this.createToLLVMNode());
                                        this.cachedType1_cache = s2_;
                                        this.exclude_ = exclude |= 1;
                                        this.cachedType0_cache = null;
                                        state &= 0xFFFFFFFE;
                                        this.state_ = state |= 2;
                                    }
                                    if (s2_ != null) {
                                        lock.unlock();
                                        hasLock = false;
                                        Object object3 = this.doCachedType(arg0Value_, arg1Value_, arg2Value, s2_.cachedType_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), s2_.dataEscapeNodes_, s2_.toLLVMNode_);
                                        return object3;
                                    }
                                }
                                finally {
                                    NodeUtil.popEncapsulatingNode((Node)prev_);
                                }
                            }
                            if ((exclude & 4) == 0) {
                                Generic0Data s3_ = this.generic0_cache;
                                boolean Generic0_duplicateFound_ = false;
                                if ((state & 4) != 0 && s3_.crossLanguageCall_.accepts((Object)arg0Value_)) {
                                    Generic0_duplicateFound_ = true;
                                }
                                if (!Generic0_duplicateFound_ && (state & 4) == 0) {
                                    s3_ = (Generic0Data)super.insert((Node)new Generic0Data());
                                    s3_.crossLanguageCall_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.create((Object)arg0Value_));
                                    s3_.dataEscapeNodes_ = s3_.insertAccessor(this.createLLVMDataEscapeNodes());
                                    s3_.toLLVMNode_ = s3_.insertAccessor(this.createToLLVMNode());
                                    this.generic0_cache = s3_;
                                    this.exclude_ = exclude |= 3;
                                    this.cachedType0_cache = null;
                                    this.cachedType1_cache = null;
                                    state &= 0xFFFFFFFC;
                                    this.state_ = state |= 4;
                                    Generic0_duplicateFound_ = true;
                                }
                                if (Generic0_duplicateFound_) {
                                    lock.unlock();
                                    hasLock = false;
                                    object = this.doGeneric(arg0Value_, arg1Value_, arg2Value, s3_.crossLanguageCall_, s3_.dataEscapeNodes_, s3_.toLLVMNode_);
                                    return object;
                                }
                            }
                            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                            try {
                                Generic1Data s4_ = (Generic1Data)super.insert((Node)new Generic1Data());
                                s4_.dataEscapeNodes_ = s4_.insertAccessor(this.createLLVMDataEscapeNodes());
                                s4_.toLLVMNode_ = s4_.insertAccessor(this.createToLLVMNode());
                                this.generic1_cache = s4_;
                                this.exclude_ = exclude |= 7;
                                this.cachedType0_cache = null;
                                this.cachedType1_cache = null;
                                this.generic0_cache = null;
                                state &= 0xFFFFFFF8;
                                this.state_ = state |= 8;
                                lock.unlock();
                                hasLock = false;
                                object = this.doGeneric(arg0Value_, arg1Value_, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), s4_.dataEscapeNodes_, s4_.toLLVMNode_);
                                return object;
                            }
                            finally {
                                NodeUtil.popEncapsulatingNode((Node)prev_);
                            }
                        }
                        while (!(s5_ == null || s5_.crossLanguageCall_.accepts((Object)arg0Value_) && arg1Value == null)) {
                            s5_ = s5_.next_;
                            ++count5_;
                        }
                    }
                    if (s5_ == null && arg1Value == null && count5_ < 5) {
                        s5_ = (UnknownType0Data)super.insert((Node)new UnknownType0Data(this.unknownType0_cache));
                        s5_.crossLanguageCall_ = (InteropLibrary)s5_.insertAccessor(INTEROP_LIBRARY_.create((Object)arg0Value_));
                        s5_.dataEscapeNodes_ = s5_.insertAccessor(this.createLLVMDataEscapeNodes());
                        s5_.toLLVMNode_ = s5_.insertAccessor(this.createToLLVMNode());
                        this.unknownType0_cache = s5_;
                        this.state_ = state |= 0x10;
                    }
                    if (s5_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doUnknownType(arg0Value_, arg1Value, arg2Value, s5_.crossLanguageCall_, s5_.dataEscapeNodes_, s5_.toLLVMNode_);
                        return object;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value != null) throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                    UnknownType1Data s6_ = (UnknownType1Data)super.insert((Node)new UnknownType1Data());
                    s6_.dataEscapeNodes_ = s6_.insertAccessor(this.createLLVMDataEscapeNodes());
                    s6_.toLLVMNode_ = s6_.insertAccessor(this.createToLLVMNode());
                    this.unknownType1_cache = s6_;
                    this.exclude_ = exclude |= 8;
                    this.unknownType0_cache = null;
                    state &= 0xFFFFFFEF;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doUnknownType(arg0Value_, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), s6_.dataEscapeNodes_, s6_.toLLVMNode_);
                    return object;
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                CachedType0Data s1_ = this.cachedType0_cache;
                CachedType1Data s2_ = this.cachedType1_cache;
                UnknownType0Data s5_ = this.unknownType0_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null || s5_ != null && s5_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDispatchNode.LLVMLookupDispatchForeignNode create(FunctionType type) {
            return new LLVMLookupDispatchForeignNodeGen(type);
        }

        @GeneratedBy(value=LLVMDispatchNode.LLVMLookupDispatchForeignNode.class)
        private static final class UnknownType1Data
        extends Node {
            @Node.Children
            LLVMDataEscapeNode[] dataEscapeNodes_;
            @Node.Child
            ForeignToLLVM toLLVMNode_;

            UnknownType1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMDispatchNode.LLVMLookupDispatchForeignNode.class)
        private static final class UnknownType0Data
        extends Node {
            @Node.Child
            UnknownType0Data next_;
            @Node.Child
            InteropLibrary crossLanguageCall_;
            @Node.Children
            LLVMDataEscapeNode[] dataEscapeNodes_;
            @Node.Child
            ForeignToLLVM toLLVMNode_;

            UnknownType0Data(UnknownType0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMDispatchNode.LLVMLookupDispatchForeignNode.class)
        private static final class Generic1Data
        extends Node {
            @Node.Children
            LLVMDataEscapeNode[] dataEscapeNodes_;
            @Node.Child
            ForeignToLLVM toLLVMNode_;

            Generic1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMDispatchNode.LLVMLookupDispatchForeignNode.class)
        private static final class Generic0Data
        extends Node {
            @Node.Child
            InteropLibrary crossLanguageCall_;
            @Node.Children
            LLVMDataEscapeNode[] dataEscapeNodes_;
            @Node.Child
            ForeignToLLVM toLLVMNode_;

            Generic0Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMDispatchNode.LLVMLookupDispatchForeignNode.class)
        private static final class CachedType1Data
        extends Node {
            @Node.Child
            CachedType1Data next_;
            @CompilerDirectives.CompilationFinal
            LLVMInteropType.Function cachedType_;
            @Node.Children
            LLVMDataEscapeNode[] dataEscapeNodes_;
            @Node.Child
            ForeignToLLVM toLLVMNode_;

            CachedType1Data(CachedType1Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMDispatchNode.LLVMLookupDispatchForeignNode.class)
        private static final class CachedType0Data
        extends Node {
            @Node.Child
            CachedType0Data next_;
            @CompilerDirectives.CompilationFinal
            LLVMInteropType.Function cachedType_;
            @Node.Child
            InteropLibrary crossLanguageCall_;
            @Node.Children
            LLVMDataEscapeNode[] dataEscapeNodes_;
            @Node.Child
            ForeignToLLVM toLLVMNode_;

            CachedType0Data(CachedType0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDispatchNode.class)
    private static final class NativeData
    extends Node {
        @Node.Child
        NativeData next_;
        @Node.Children
        LLVMNativeConvertNode[] toNative_;
        @Node.Child
        LLVMNativeConvertNode fromNative_;
        @Node.Child
        InteropLibrary nativeCall_;
        @Node.Child
        InteropLibrary bind_;
        @Node.Child
        LLVMFunctionDescriptor.ResolveFunctionNode resolve_;
        @CompilerDirectives.CompilationFinal
        boolean statistics_;

        NativeData(NativeData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMDispatchNode.class)
    private static final class CachedNativeData
    extends Node {
        @Node.Child
        CachedNativeData next_;
        @CompilerDirectives.CompilationFinal
        LLVMFunctionDescriptor cachedDescriptor_;
        @Node.Children
        LLVMNativeConvertNode[] toNative_;
        @Node.Child
        LLVMNativeConvertNode fromNative_;
        @CompilerDirectives.CompilationFinal
        Object cachedBoundFunction_;
        @Node.Child
        InteropLibrary nativeCall_;
        @CompilerDirectives.CompilationFinal
        boolean statistics_;

        CachedNativeData(CachedNativeData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMDispatchNode.class)
    private static final class IndirectIntrinsicData
    extends Node {
        @Node.Child
        IndirectIntrinsicData next_;
        @Node.Child
        LLVMFunctionDescriptor.ResolveFunctionNode resolve_;
        @Node.Child
        IndirectCallNode callNode_;

        IndirectIntrinsicData(IndirectIntrinsicData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMDispatchNode.class)
    private static final class DirectIntrinsicData
    extends Node {
        @Node.Child
        DirectIntrinsicData next_;
        @CompilerDirectives.CompilationFinal
        LLVMFunctionDescriptor cachedFunction_;
        @Node.Child
        DirectCallNode callNode_;

        DirectIntrinsicData(DirectIntrinsicData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMDispatchNode.class)
    private static final class DirectData
    extends Node {
        @Node.Child
        DirectData next_;
        @CompilerDirectives.CompilationFinal
        LLVMFunctionDescriptor cachedFunction_;
        @Node.Child
        DirectCallNode callNode_;

        DirectData(DirectData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

