/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMBitcodeLibraryFunctions;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValueNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMLandingpadNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode getStack;
    @Node.Child
    private LLVMExpressionNode allocateLandingPadValue;
    @Node.Child
    private LLVMPointerStoreNode writePointer;
    @Node.Child
    private LLVMI32StoreNode writeI32;
    @Node.Children
    private final LandingpadEntryNode[] entries;
    private final FrameSlot exceptionSlot;
    private final boolean cleanup;

    public LLVMLandingpadNode(LLVMExpressionNode getStack, LLVMExpressionNode allocateLandingPadValue, FrameSlot exceptionSlot, boolean cleanup, LandingpadEntryNode[] entries) {
        this.getStack = getStack;
        this.allocateLandingPadValue = allocateLandingPadValue;
        this.writePointer = LLVMPointerStoreNodeGen.create(null, null);
        this.writeI32 = LLVMI32StoreNodeGen.create(null, null);
        this.exceptionSlot = exceptionSlot;
        this.cleanup = cleanup;
        this.entries = entries;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        try {
            LLVMUserException exception = (LLVMUserException)frame.getObject(this.exceptionSlot);
            LLVMPointer unwindHeader = exception.getUnwindHeader();
            LLVMStack.StackPointer stack = (LLVMStack.StackPointer)this.getStack.executeGeneric(frame);
            int clauseId = this.getEntryIdentifier(frame, stack, unwindHeader);
            if (clauseId == 0 && !this.cleanup) {
                throw exception;
            }
            LLVMPointer landingPadValue = this.allocateLandingPadValue.executeLLVMPointer(frame);
            this.writePointer.executeWithTarget(landingPadValue, unwindHeader);
            this.writeI32.executeWithTarget(landingPadValue.increment(8L), clauseId);
            return landingPadValue;
        }
        catch (FrameSlotTypeException | UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }

    @ExplodeLoop
    private int getEntryIdentifier(VirtualFrame frame, LLVMStack.StackPointer stack, LLVMPointer unwindHeader) {
        for (int i = 0; i < this.entries.length; ++i) {
            int clauseId = this.entries[i].getIdentifier(frame, stack, unwindHeader);
            if (clauseId == 0) continue;
            return clauseId;
        }
        return 0;
    }

    public static final class LandingpadFilterEntryNode
    extends LandingpadEntryNode {
        @Node.Children
        private final LLVMExpressionNode[] filterTypes;
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongCanCatchNode canCatch;

        public LandingpadFilterEntryNode(LLVMExpressionNode[] filterTypes) {
            this.filterTypes = filterTypes;
        }

        public LLVMBitcodeLibraryFunctions.SulongCanCatchNode getCanCatch() {
            if (this.canCatch == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                LLVMContext context = (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
                this.canCatch = (LLVMBitcodeLibraryFunctions.SulongCanCatchNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongCanCatchNode(context));
            }
            return this.canCatch;
        }

        @Override
        public int getIdentifier(VirtualFrame frame, LLVMStack.StackPointer stack, LLVMPointer unwindHeader) {
            if (!this.filterMatches(frame, stack, unwindHeader)) {
                return -1;
            }
            return 0;
        }

        @ExplodeLoop
        private boolean filterMatches(VirtualFrame frame, LLVMStack.StackPointer stack, LLVMPointer unwindHeader) {
            try {
                for (int i = 0; i < this.filterTypes.length; ++i) {
                    LLVMPointer filterAddress = this.filterTypes[i].executeLLVMPointer(frame);
                    if (filterAddress.isNull()) {
                        return true;
                    }
                    if (this.getCanCatch().canCatch(stack, unwindHeader, filterAddress) == 0) continue;
                    return true;
                }
                return false;
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }
    }

    public static final class LandingpadCatchEntryNode
    extends LandingpadEntryNode {
        @Node.Child
        private LLVMExpressionNode catchType;
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongCanCatchNode canCatch;
        @Node.Child
        private ToComparableValue toComparableValue;

        public LandingpadCatchEntryNode(LLVMExpressionNode catchType) {
            this.catchType = catchType;
            this.toComparableValue = ToComparableValueNodeGen.create();
        }

        public LLVMBitcodeLibraryFunctions.SulongCanCatchNode getCanCatch() {
            if (this.canCatch == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                LLVMContext context = (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
                this.canCatch = (LLVMBitcodeLibraryFunctions.SulongCanCatchNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongCanCatchNode(context));
            }
            return this.canCatch;
        }

        @Override
        public int getIdentifier(VirtualFrame frame, LLVMStack.StackPointer stack, LLVMPointer unwindHeader) {
            try {
                LLVMPointer catchAddress = this.catchType.executeLLVMPointer(frame);
                if (catchAddress.isNull()) {
                    return 1;
                }
                if (this.getCanCatch().canCatch(stack, unwindHeader, catchAddress) != 0) {
                    return (int)this.toComparableValue.executeWithTarget(catchAddress);
                }
                return 0;
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }
    }

    public static abstract class LandingpadEntryNode
    extends LLVMExpressionNode {
        public abstract int getIdentifier(VirtualFrame var1, LLVMStack.StackPointer var2, LLVMPointer var3);

        @Override
        public final Object executeGeneric(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }
    }
}

