/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(value="function", type=LLVMExpressionNode.class)
public abstract class LLVMLookupDispatchTargetNode
extends LLVMExpressionNode {
    protected static final int INLINE_CACHE_SIZE = 5;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory llvmMemory;
    @Node.Child
    private LLVMDerefHandleGetReceiverNode derefHandleGetReceiverNode;

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"isSameObject(pointer.getObject(), cachedDescriptor)", "cachedDescriptor != null", "pointer.getOffset() == 0"})
    protected static LLVMFunctionDescriptor doDirectCached(LLVMManagedPointer pointer, @Cached(value="asFunctionDescriptor(pointer.getObject())") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(guards={"isFunctionDescriptor(pointer.getObject())", "pointer.getOffset() == 0"}, replaces={"doDirectCached"})
    protected static LLVMFunctionDescriptor doDirect(LLVMManagedPointer pointer) {
        return (LLVMFunctionDescriptor)pointer.getObject();
    }

    @Specialization(guards={"isForeignFunction(pointer.getObject())", "pointer.getOffset() == 0"})
    protected LLVMTypedForeignObject doForeign(LLVMManagedPointer pointer) {
        return (LLVMTypedForeignObject)pointer.getObject();
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor != null"})
    protected static LLVMFunctionDescriptor doHandleCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="lookupFunction(ctxRef, pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return cachedDescriptor;
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"pointer.asNative() == cachedAddress", "!isAutoDerefHandle(cachedAddress)", "cachedDescriptor == null"})
    protected static LLVMNativePointer doNativeFunctionCached(LLVMNativePointer pointer, @Cached(value="pointer.asNative()") long cachedAddress, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="lookupFunction(ctxRef, pointer)") LLVMFunctionDescriptor cachedDescriptor) {
        return pointer;
    }

    @Specialization(guards={"!isAutoDerefHandle(pointer.asNative())"}, replaces={"doHandleCached", "doNativeFunctionCached"})
    protected Object doLookup(LLVMNativePointer pointer, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        LLVMFunctionDescriptor descriptor = this.lookupFunction(ctxRef, pointer);
        if (descriptor != null) {
            return descriptor;
        }
        return pointer;
    }

    @Specialization(guards={"isAutoDerefHandle(pointer.asNative())"})
    protected LLVMTypedForeignObject doDerefHandle(LLVMNativePointer pointer) {
        LLVMManagedPointer foreignFunction = this.getDerefHandleGetReceiverNode().execute(pointer);
        return this.doForeign(foreignFunction);
    }

    protected LLVMFunctionDescriptor lookupFunction(TruffleLanguage.ContextReference<LLVMContext> ctxRef, LLVMNativePointer function) {
        return ((LLVMContext)ctxRef.get()).getFunctionDescriptor(function);
    }

    protected static boolean isForeignFunction(Object object) {
        return object instanceof LLVMTypedForeignObject;
    }

    protected final LLVMMemory getLLVMMemoryCached() {
        if (this.llvmMemory == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.llvmMemory = LLVMLookupDispatchTargetNode.getLLVMMemory();
        }
        return this.llvmMemory;
    }

    protected boolean isAutoDerefHandle(long addr) {
        return this.getLLVMMemoryCached().isDerefHandleMemory(addr);
    }

    protected LLVMDerefHandleGetReceiverNode getDerefHandleGetReceiverNode() {
        if (this.derefHandleGetReceiverNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.derefHandleGetReceiverNode = (LLVMDerefHandleGetReceiverNode)this.insert(LLVMDerefHandleGetReceiverNode.create());
        }
        return this.derefHandleGetReceiverNode;
    }
}

