/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChild(value="object", type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotBoxedPredicate
extends LLVMIntrinsic {
    final Predicate predicate;

    protected LLVMPolyglotBoxedPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    @Specialization
    boolean matchManaged(LLVMManagedPointer object, @Cached(value="createOptional()") LLVMAsForeignNode asForeign, @Cached(value="createBinaryProfile()") ConditionProfile isForeign, @CachedLibrary(limit="3") InteropLibrary interop) {
        Object foreign = asForeign.execute(object);
        if (isForeign.profile(foreign != null)) {
            return this.predicate.match(interop, foreign);
        }
        return false;
    }

    @Specialization(limit="1")
    boolean matchString(String str, @CachedLibrary(value="str") InteropLibrary interop) {
        return this.predicate.match(interop, str);
    }

    @Fallback
    public boolean fallback(Object object) {
        return false;
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean match(InteropLibrary var1, Object var2);
    }
}

