/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChildren(value={@NodeChild(value="object", type=LLVMExpressionNode.class), @NodeChild(value="name", type=LLVMExpressionNode.class)})
public abstract class LLVMPolyglotHasMember
extends LLVMIntrinsic {
    @Specialization
    protected boolean doHasMember(LLVMManagedPointer object, Object name, @Cached LLVMAsForeignNode asForeign, @Cached LLVMReadStringNode readString, @CachedLibrary(limit="3") InteropLibrary interop) {
        Object foreign = asForeign.execute(object);
        String id = readString.executeWithTarget(name);
        return interop.isMemberExisting(foreign, id);
    }

    @Fallback
    public Object fallback(Object object, Object name) {
        throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
    }
}

