/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTruffleCannotBeHandle
extends LLVMIntrinsic {
    @CompilerDirectives.CompilationFinal
    private LLVMMemory llvmMemory;

    @Specialization
    protected boolean doLongCase(long a) {
        return !this.getLLVMMemoryCached().isHandleMemory(a);
    }

    @Specialization
    protected boolean doPointerCase(LLVMNativePointer a) {
        return this.doLongCase(a.asNative());
    }

    @Fallback
    protected boolean doGeneric(Object object) {
        return true;
    }

    private LLVMMemory getLLVMMemoryCached() {
        if (this.llvmMemory == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.llvmMemory = LLVMTruffleCannotBeHandle.getLLVMMemory();
        }
        return this.llvmMemory;
    }
}

