/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTruffleIsHandleToManaged
extends LLVMIntrinsic {
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memory;

    @Specialization
    protected boolean doLongCase(long a, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context) {
        return this.doPointerCase(LLVMNativePointer.create(a), context);
    }

    @Specialization
    protected boolean doPointerCase(LLVMNativePointer a, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context) {
        if (this.canBeHandle(a)) {
            return ((LLVMContext)context.get()).isHandle(a);
        }
        return false;
    }

    private boolean canBeHandle(LLVMNativePointer a) {
        if (this.memory == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.memory = LLVMTruffleIsHandleToManaged.getLLVMMemory();
        }
        return this.memory.isHandleMemory(a.asNative());
    }

    @Fallback
    protected boolean doGeneric(Object object) {
        return false;
    }
}

