/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMStackSave;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMStackSave.class)
public final class LLVMStackSaveNodeGen
extends LLVMStackSave {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memory_;

    private LLVMStackSaveNodeGen() {
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if (state != 0) {
            return this.doPointee(frameValue, this.memory_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            this.memory_ = LLVMNode.getLLVMMemory();
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            LLVMNativePointer lLVMNativePointer = this.doPointee(frameValue, this.memory_);
            return lLVMNativePointer;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMStackSave create() {
        return new LLVMStackSaveNodeGen();
    }
}

