/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBConstant;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.math.BigInteger;

abstract class LLDBVector
extends LLDBConstant {
    private final int elementSize;
    private final int length;

    LLDBVector(int elementSize, int length) {
        this.elementSize = elementSize;
        this.length = length;
    }

    int getIndex(long bitOffset) {
        return (int)bitOffset / this.elementSize;
    }

    int getElementSize() {
        return this.elementSize;
    }

    @Override
    public boolean canRead(long bitOffset, int bits) {
        return bitOffset % (long)this.elementSize == 0L && (bits == this.elementSize || bits == this.elementSize * this.length) && bitOffset + (long)bits <= (long)(this.elementSize * this.length);
    }

    @Override
    public Object computeAddress(long bitOffset) {
        return "Vector";
    }

    static final class Address
    extends LLDBVector {
        private final LLVMPointerVector value;

        Address(LLVMPointerVector value) {
            super(64, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public Object readAddress(long bitOffset) {
            if (this.canRead(bitOffset, this.getElementSize())) {
                return this.value.getValue(this.getIndex(bitOffset));
            }
            return super.readAddress(bitOffset);
        }
    }

    static final class Double
    extends LLDBVector {
        private final LLVMDoubleVector value;

        Double(LLVMDoubleVector value) {
            super(64, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public Object readDouble(long bitOffset) {
            if (this.canRead(bitOffset, this.getElementSize())) {
                return this.value.getValue(this.getIndex(bitOffset));
            }
            return super.readDouble(bitOffset);
        }
    }

    static final class Float
    extends LLDBVector {
        private final LLVMFloatVector value;

        Float(LLVMFloatVector value) {
            super(32, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public Object readFloat(long bitOffset) {
            if (this.canRead(bitOffset, this.getElementSize())) {
                return java.lang.Float.valueOf(this.value.getValue(this.getIndex(bitOffset)));
            }
            return super.readFloat(bitOffset);
        }
    }

    static final class I64
    extends LLDBVector {
        private final LLVMI64Vector value;

        I64(LLVMI64Vector value) {
            super(64, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if (!this.canRead(bitOffset, bitSize)) {
                return super.readBigInteger(bitOffset, bitSize, signed);
            }
            if (signed) {
                return BigInteger.valueOf(this.value.getValue(this.getIndex(bitOffset)));
            }
            return new BigInteger(Long.toUnsignedString(this.value.getValue(this.getIndex(bitOffset))));
        }
    }

    static final class I32
    extends LLDBVector {
        private final LLVMI32Vector value;

        I32(LLVMI32Vector value) {
            super(32, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if (!this.canRead(bitOffset, bitSize)) {
                return super.readBigInteger(bitOffset, bitSize, signed);
            }
            if (signed) {
                return BigInteger.valueOf(this.value.getValue(this.getIndex(bitOffset)));
            }
            return BigInteger.valueOf(Integer.toUnsignedLong(this.value.getValue(this.getIndex(bitOffset))));
        }
    }

    static final class I16
    extends LLDBVector {
        private final LLVMI16Vector value;

        I16(LLVMI16Vector value) {
            super(16, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if (!this.canRead(bitOffset, bitSize)) {
                return super.readBigInteger(bitOffset, bitSize, signed);
            }
            if (signed) {
                return BigInteger.valueOf(this.value.getValue(this.getIndex(bitOffset)));
            }
            return BigInteger.valueOf(Short.toUnsignedLong(this.value.getValue(this.getIndex(bitOffset))));
        }
    }

    static final class I8
    extends LLDBVector {
        private final LLVMI8Vector value;

        I8(LLVMI8Vector value) {
            super(8, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if (!this.canRead(bitOffset, bitSize)) {
                return super.readBigInteger(bitOffset, bitSize, signed);
            }
            if (signed) {
                return BigInteger.valueOf(this.value.getValue(this.getIndex(bitOffset)));
            }
            return BigInteger.valueOf(Byte.toUnsignedLong(this.value.getValue(this.getIndex(bitOffset))));
        }
    }

    static final class I1
    extends LLDBVector {
        private final LLVMI1Vector value;

        I1(LLVMI1Vector value) {
            super(1, value.getLength());
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public Object readBoolean(long bitOffset) {
            if (this.canRead(bitOffset, 1)) {
                return this.value.getValue(this.getIndex(bitOffset));
            }
            return super.readBoolean(bitOffset);
        }
    }
}

