/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugAggregateObjectBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugSimpleObjectBuilder;

@NodeChild(value="llvmValueRead", type=LLVMExpressionNode.class)
public abstract class LLVMDebugWriteNode
extends LLVMStatementNode {
    private final LLVMDebugBuilder builder;

    protected LLVMDebugWriteNode(LLVMDebugBuilder builder) {
        this.builder = builder;
    }

    protected LLVMDebugValue.Builder createBuilder() {
        return this.builder.createBuilder();
    }

    @NodeChild(value="containerRead", type=LLVMExpressionNode.class)
    public static abstract class AggregateWriteNode
    extends LLVMDebugWriteNode {
        private final int partIndex;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] clearIndices;

        protected AggregateWriteNode(LLVMDebugBuilder builder, int partIndex, int[] clearIndices) {
            super(builder);
            this.partIndex = partIndex;
            this.clearIndices = clearIndices;
        }

        @Specialization
        protected void setPart(LLVMDebugAggregateObjectBuilder container, Object partLLVMValue, @Cached(value="createBuilder()") LLVMDebugValue.Builder valueProcessor) {
            container.setPart(this.partIndex, valueProcessor, partLLVMValue);
            this.clearIndices(container);
        }

        @ExplodeLoop
        private void clearIndices(LLVMDebugAggregateObjectBuilder value) {
            for (int i : this.clearIndices) {
                value.clear(i);
            }
        }
    }

    public static abstract class SimpleWriteNode
    extends LLVMDebugWriteNode {
        private final FrameSlot slot;

        protected SimpleWriteNode(LLVMDebugBuilder builder, FrameSlot slot) {
            super(builder);
            this.slot = slot;
        }

        @Specialization
        protected void write(VirtualFrame frame, Object llvmValue, @Cached(value="createBuilder()") LLVMDebugValue.Builder valueProcessor) {
            frame.setObject(this.slot, (Object)new LLVMDebugSimpleObjectBuilder(valueProcessor, llvmValue));
        }
    }
}

