/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;

public abstract class LLVMX86_ComparisonNode {

    @NodeChildren(value={@NodeChild(value="xmm1", type=LLVMExpressionNode.class), @NodeChild(value="xmm2", type=LLVMExpressionNode.class), @NodeChild(value="imm", type=LLVMExpressionNode.class)})
    public static abstract class LLVMX86_Cmpss
    extends LLVMBuiltin {
        private static float TRUEMASK = Float.intBitsToFloat(-1);

        @Specialization
        protected LLVMFloatVector doIntrinsic(LLVMFloatVector xmm1, LLVMFloatVector xmm2, byte imm) {
            if (xmm1.getLength() != 4) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)"xmm1 expected a <4 x float> vector");
            }
            if (xmm2.getLength() != 4) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)"xmm2 expected a <4 x float> vector");
            }
            float[] rv = new float[]{0.0f, xmm1.getValue(1), xmm1.getValue(2), xmm1.getValue(3)};
            float left = xmm1.getValue(0);
            float right = xmm2.getValue(0);
            switch (imm) {
                case 0: {
                    rv[0] = left == right ? TRUEMASK : 0.0f;
                    break;
                }
                case 1: {
                    rv[0] = left < right ? TRUEMASK : 0.0f;
                    break;
                }
                case 2: {
                    rv[0] = left <= right ? TRUEMASK : 0.0f;
                    break;
                }
                case 3: {
                    rv[0] = Float.isNaN(left) || Float.isNaN(right) ? TRUEMASK : 0.0f;
                    break;
                }
                case 4: {
                    rv[0] = left == right ? 0.0f : TRUEMASK;
                    break;
                }
                case 5: {
                    rv[0] = left < right ? 0.0f : TRUEMASK;
                    break;
                }
                case 6: {
                    rv[0] = left <= right ? 0.0f : TRUEMASK;
                    break;
                }
                case 7: {
                    rv[0] = Float.isNaN(left) || Float.isNaN(right) ? 0.0f : TRUEMASK;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unsupported predicate (not in range 0-7)");
                }
            }
            return LLVMFloatVector.create(rv);
        }
    }
}

