/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_VectorMathNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMX86_VectorMathNode.class)
public final class LLVMX86_VectorMathNodeFactory {

    @GeneratedBy(value=LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.class)
    public static final class LLVMX86_VectorCmpNodeGen
    extends LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @Node.Child
        private LLVMExpressionNode child2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private Cmp0Data cmp0_cache;
        @CompilerDirectives.CompilationFinal
        private Cmp1Data cmp1_cache;

        private LLVMX86_VectorCmpNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1, LLVMExpressionNode child2) {
            this.child0_ = child0;
            this.child1_ = child1;
            this.child2_ = child2;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state, child0Value_, child1Value_);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_byte1(frameValue, state, child0Value_, child1Value_);
            }
            return this.executeGeneric_generic2(frameValue, state, child0Value_, child1Value_);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_int0(VirtualFrame frameValue, int state, Object child0Value_, Object child1Value_) {
            int child2Value_;
            try {
                child2Value_ = this.child2_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, child1Value_, ex.getResult());
            }
            assert ((state & 1) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if (child1Value_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child1Value__ = (LLVMDoubleVector)child1Value_;
                    if (child0Value__.getLength() == 2 && child1Value__.getLength() == 2) {
                        Cmp0Data s1_ = this.cmp0_cache;
                        while (s1_ != null) {
                            if (child2Value_ == s1_.cachedPredicate_) {
                                return this.doCmp(child0Value__, child1Value__, child2Value_, s1_.cachedPredicate_, s1_.comparator_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, child2Value_);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_byte1(VirtualFrame frameValue, int state, Object child0Value_, Object child1Value_) {
            byte child2Value_;
            try {
                child2Value_ = this.child2_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(child0Value_, child1Value_, ex.getResult());
            }
            assert ((state & 2) != 0);
            if (child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if (child1Value_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child1Value__ = (LLVMDoubleVector)child1Value_;
                    if (child0Value__.getLength() == 2 && child1Value__.getLength() == 2) {
                        Cmp1Data s2_ = this.cmp1_cache;
                        while (s2_ != null) {
                            if (child2Value_ == s2_.cachedPredicate_) {
                                return this.doCmp(child0Value__, child1Value__, child2Value_, s2_.cachedPredicate_, s2_.comparator_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, child2Value_);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private Object executeGeneric_generic2(VirtualFrame frameValue, int state, Object child0Value_, Object child1Value_) {
            Object child2Value_ = this.child2_.executeGeneric(frameValue);
            if (state != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if (child1Value_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child1Value__ = (LLVMDoubleVector)child1Value_;
                    if ((state & 1) != 0 && child2Value_ instanceof Integer) {
                        int n = (Integer)child2Value_;
                        if (child0Value__.getLength() == 2 && child1Value__.getLength() == 2) {
                            Cmp0Data s1_ = this.cmp0_cache;
                            while (s1_ != null) {
                                if (n == s1_.cachedPredicate_) {
                                    return this.doCmp(child0Value__, child1Value__, n, s1_.cachedPredicate_, s1_.comparator_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                    }
                    if ((state & 2) != 0 && child2Value_ instanceof Byte) {
                        byte by = (Byte)child2Value_;
                        if (child0Value__.getLength() == 2 && child1Value__.getLength() == 2) {
                            Cmp1Data s2_ = this.cmp1_cache;
                            while (s2_ != null) {
                                if (by == s2_.cachedPredicate_) {
                                    return this.doCmp(child0Value__, child1Value__, by, s2_.cachedPredicate_, s2_.comparator_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_, child2Value_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object child0Value, Object child1Value, Object child2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (child0Value instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                    if (child1Value instanceof LLVMDoubleVector) {
                        LLVMDoubleVector child1Value_ = (LLVMDoubleVector)child1Value;
                        if (child2Value instanceof Integer) {
                            int n = (Integer)child2Value;
                            if (child0Value_.getLength() == 2 && child1Value_.getLength() == 2) {
                                int count1_ = 0;
                                Cmp0Data s1_ = this.cmp0_cache;
                                if ((state & 1) != 0) {
                                    while (s1_ != null && n != s1_.cachedPredicate_) {
                                        s1_ = s1_.next_;
                                        ++count1_;
                                    }
                                }
                                if (s1_ == null && count1_ < LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.cmpCnt) {
                                    s1_ = new Cmp0Data(this.cmp0_cache);
                                    s1_.cachedPredicate_ = n;
                                    s1_.comparator_ = LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.getComparator(n);
                                    this.cmp0_cache = s1_;
                                    this.state_ = state |= 1;
                                }
                                if (s1_ != null) {
                                    lock.unlock();
                                    hasLock = false;
                                    LLVMDoubleVector lLVMDoubleVector = this.doCmp(child0Value_, child1Value_, n, s1_.cachedPredicate_, s1_.comparator_);
                                    return lLVMDoubleVector;
                                }
                            }
                        }
                        if (child2Value instanceof Byte) {
                            byte by = (Byte)child2Value;
                            if (child0Value_.getLength() == 2 && child1Value_.getLength() == 2) {
                                int count2_ = 0;
                                Cmp1Data s2_ = this.cmp1_cache;
                                if ((state & 2) != 0) {
                                    while (s2_ != null && by != s2_.cachedPredicate_) {
                                        s2_ = s2_.next_;
                                        ++count2_;
                                    }
                                }
                                if (s2_ == null && count2_ < LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.cmpCnt) {
                                    s2_ = new Cmp1Data(this.cmp1_cache);
                                    s2_.cachedPredicate_ = by;
                                    s2_.comparator_ = LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.getComparator(by);
                                    this.cmp1_cache = s2_;
                                    this.state_ = state |= 2;
                                }
                                if (s2_ != null) {
                                    lock.unlock();
                                    hasLock = false;
                                    LLVMDoubleVector lLVMDoubleVector = this.doCmp(child0Value_, child1Value_, by, s2_.cachedPredicate_, s2_.comparator_);
                                    return lLVMDoubleVector;
                                }
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_, this.child2_}, new Object[]{child0Value, child1Value, child2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                Cmp0Data s1_ = this.cmp0_cache;
                Cmp1Data s2_ = this.cmp1_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode create(LLVMExpressionNode child0, LLVMExpressionNode child1, LLVMExpressionNode child2) {
            return new LLVMX86_VectorCmpNodeGen(child0, child1, child2);
        }

        @GeneratedBy(value=LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.class)
        private static final class Cmp1Data {
            @CompilerDirectives.CompilationFinal
            Cmp1Data next_;
            @CompilerDirectives.CompilationFinal
            byte cachedPredicate_;
            @CompilerDirectives.CompilationFinal
            LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.Comparator comparator_;

            Cmp1Data(Cmp1Data next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.class)
        private static final class Cmp0Data {
            @CompilerDirectives.CompilationFinal
            Cmp0Data next_;
            @CompilerDirectives.CompilationFinal
            int cachedPredicate_;
            @CompilerDirectives.CompilationFinal
            LLVMX86_VectorMathNode.LLVMX86_VectorCmpNode.Comparator comparator_;

            Cmp0Data(Cmp0Data next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMX86_VectorMathNode.LLVMX86_VectorPackNode.class)
    public static final class LLVMX86_VectorPackNodeGen
    extends LLVMX86_VectorMathNode.LLVMX86_VectorPackNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMX86_VectorPackNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMVector child1Value__;
            LLVMVector child0Value__;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof LLVMI32Vector) {
                child0Value__ = (LLVMI32Vector)child0Value_;
                if (child1Value_ instanceof LLVMI32Vector) {
                    child1Value__ = (LLVMI32Vector)child1Value_;
                    if (((LLVMI32Vector)child0Value__).getLength() == 4 && ((LLVMI32Vector)child1Value__).getLength() == 4) {
                        return this.doPacksswd((LLVMI32Vector)child0Value__, (LLVMI32Vector)child1Value__);
                    }
                }
            }
            if ((state & 2) != 0 && child0Value_ instanceof LLVMI16Vector) {
                child0Value__ = (LLVMI16Vector)child0Value_;
                if (child1Value_ instanceof LLVMI16Vector) {
                    child1Value__ = (LLVMI16Vector)child1Value_;
                    if (((LLVMI16Vector)child0Value__).getLength() == 8 && ((LLVMI16Vector)child1Value__).getLength() == 8) {
                        return this.doPacksswb((LLVMI16Vector)child0Value__, (LLVMI16Vector)child1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private LLVMVector executeAndSpecialize(Object child0Value, Object child1Value) {
            LLVMVector child1Value_;
            LLVMVector child0Value_;
            int state = this.state_;
            if (child0Value instanceof LLVMI32Vector) {
                child0Value_ = (LLVMI32Vector)child0Value;
                if (child1Value instanceof LLVMI32Vector) {
                    child1Value_ = (LLVMI32Vector)child1Value;
                    if (((LLVMI32Vector)child0Value_).getLength() == 4 && ((LLVMI32Vector)child1Value_).getLength() == 4) {
                        this.state_ = state |= 1;
                        return this.doPacksswd((LLVMI32Vector)child0Value_, (LLVMI32Vector)child1Value_);
                    }
                }
            }
            if (child0Value instanceof LLVMI16Vector) {
                child0Value_ = (LLVMI16Vector)child0Value;
                if (child1Value instanceof LLVMI16Vector) {
                    child1Value_ = (LLVMI16Vector)child1Value;
                    if (((LLVMI16Vector)child0Value_).getLength() == 8 && ((LLVMI16Vector)child1Value_).getLength() == 8) {
                        this.state_ = state |= 2;
                        return this.doPacksswb((LLVMI16Vector)child0Value_, (LLVMI16Vector)child1Value_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMX86_VectorMathNode.LLVMX86_VectorPackNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMX86_VectorPackNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMX86_VectorMathNode.LLVMX86_VectorMinNode.class)
    public static final class LLVMX86_VectorMinNodeGen
    extends LLVMX86_VectorMathNode.LLVMX86_VectorMinNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMX86_VectorMinNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (state != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if (child1Value_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child1Value__ = (LLVMDoubleVector)child1Value_;
                    if (child0Value__.getLength() == 2 && child1Value__.getLength() == 2) {
                        return this.doM128(child0Value__, child1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                if (child1Value instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child1Value_ = (LLVMDoubleVector)child1Value;
                    if (child0Value_.getLength() == 2 && child1Value_.getLength() == 2) {
                        this.state_ = state |= 1;
                        return this.doM128(child0Value_, child1Value_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMX86_VectorMathNode.LLVMX86_VectorMinNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMX86_VectorMinNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMX86_VectorMathNode.LLVMX86_VectorMaxNode.class)
    public static final class LLVMX86_VectorMaxNodeGen
    extends LLVMX86_VectorMathNode.LLVMX86_VectorMaxNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @Node.Child
        private LLVMExpressionNode child1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMX86_VectorMaxNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            this.child0_ = child0;
            this.child1_ = child1;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            Object child1Value_ = this.child1_.executeGeneric(frameValue);
            if (state != 0 && child0Value_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value__ = (LLVMDoubleVector)child0Value_;
                if (child1Value_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child1Value__ = (LLVMDoubleVector)child1Value_;
                    if (child0Value__.getLength() == 2 && child1Value__.getLength() == 2) {
                        return this.doM128(child0Value__, child1Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_, child1Value_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object child0Value, Object child1Value) {
            int state = this.state_;
            if (child0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector child0Value_ = (LLVMDoubleVector)child0Value;
                if (child1Value instanceof LLVMDoubleVector) {
                    LLVMDoubleVector child1Value_ = (LLVMDoubleVector)child1Value;
                    if (child0Value_.getLength() == 2 && child1Value_.getLength() == 2) {
                        this.state_ = state |= 1;
                        return this.doM128(child0Value_, child1Value_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMX86_VectorMathNode.LLVMX86_VectorMaxNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
            return new LLVMX86_VectorMaxNodeGen(child0, child1);
        }
    }

    @GeneratedBy(value=LLVMX86_VectorMathNode.LLVMX86_VectorSquareRootNode.class)
    public static final class LLVMX86_VectorSquareRootNodeGen
    extends LLVMX86_VectorMathNode.LLVMX86_VectorSquareRootNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMX86_VectorSquareRootNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMDoubleVector child0Value__;
            int state = this.state_;
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if (state != 0 && child0Value_ instanceof LLVMDoubleVector && (child0Value__ = (LLVMDoubleVector)child0Value_).getLength() == 2) {
                return this.doM128(child0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private LLVMDoubleVector executeAndSpecialize(Object child0Value) {
            LLVMDoubleVector child0Value_;
            int state = this.state_;
            if (child0Value instanceof LLVMDoubleVector && (child0Value_ = (LLVMDoubleVector)child0Value).getLength() == 2) {
                this.state_ = state |= 1;
                return this.doM128(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMX86_VectorMathNode.LLVMX86_VectorSquareRootNode create(LLVMExpressionNode child0) {
            return new LLVMX86_VectorSquareRootNodeGen(child0);
        }
    }
}

