/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMPThreadKeyIntrinsics;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPThreadKeyIntrinsics.class)
public final class LLVMPThreadKeyIntrinsicsFactory {

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadSetSpecific.class)
    public static final class LLVMPThreadSetSpecificNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadSetSpecific {
        @Node.Child
        private LLVMExpressionNode key_;
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadSetSpecificNodeGen(LLVMExpressionNode key, LLVMExpressionNode value) {
            this.key_ = key;
            this.value_ = value;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return this.doIntrinsic(keyValue_, valueValue__, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_, valueValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), valueValue);
            }
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                return this.doIntrinsic(keyValue_, valueValue__, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_, valueValue_);
        }

        private int executeAndSpecialize(Object keyValue, Object valueValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (keyValue instanceof Integer) {
                    int keyValue_ = (Integer)keyValue;
                    if (LLVMTypes.isPointer(valueValue)) {
                        LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                        TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                        if (lLVMLanguageContextReference__ == null) {
                            this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        int n = this.doIntrinsic(keyValue_, valueValue_, (LLVMContext)lLVMLanguageContextReference__.get());
                        return n;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_, this.value_}, new Object[]{keyValue, valueValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadSetSpecific create(LLVMExpressionNode key, LLVMExpressionNode value) {
            return new LLVMPThreadSetSpecificNodeGen(key, value);
        }
    }

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadGetSpecific.class)
    public static final class LLVMPThreadGetSpecificNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadGetSpecific {
        @Node.Child
        private LLVMExpressionNode key_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadGetSpecificNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doIntrinsic(keyValue_, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        private LLVMPointer executeAndSpecialize(Object keyValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (keyValue instanceof Integer) {
                    int keyValue_ = (Integer)keyValue;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__ == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMPointer lLVMPointer = this.doIntrinsic(keyValue_, (LLVMContext)lLVMLanguageContextReference__.get());
                    return lLVMPointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_}, new Object[]{keyValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadGetSpecific create(LLVMExpressionNode key) {
            return new LLVMPThreadGetSpecificNodeGen(key);
        }
    }

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadKeyDelete.class)
    public static final class LLVMPThreadKeyDeleteNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadKeyDelete {
        @Node.Child
        private LLVMExpressionNode key_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadKeyDeleteNodeGen(LLVMExpressionNode key) {
            this.key_ = key;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doIntrinsic(keyValue_, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int keyValue_;
            int state = this.state_;
            try {
                keyValue_ = this.key_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doIntrinsic(keyValue_, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(keyValue_);
        }

        private int executeAndSpecialize(Object keyValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (keyValue instanceof Integer) {
                    int keyValue_ = (Integer)keyValue;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__ == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIntrinsic(keyValue_, (LLVMContext)lLVMLanguageContextReference__.get());
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.key_}, new Object[]{keyValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadKeyDelete create(LLVMExpressionNode key) {
            return new LLVMPThreadKeyDeleteNodeGen(key);
        }
    }

    @GeneratedBy(value=LLVMPThreadKeyIntrinsics.LLVMPThreadKeyCreate.class)
    public static final class LLVMPThreadKeyCreateNodeGen
    extends LLVMPThreadKeyIntrinsics.LLVMPThreadKeyCreate {
        @Node.Child
        private LLVMExpressionNode destructor_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

        private LLVMPThreadKeyCreateNodeGen(LLVMExpressionNode destructor) {
            this.destructor_ = destructor;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                return this.doIntrinsic(destructorValue__, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(destructorValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state = this.state_;
            Object destructorValue_ = this.destructor_.executeGeneric(frameValue);
            if (state != 0 && LLVMTypes.isPointer(destructorValue_)) {
                LLVMPointer destructorValue__ = LLVMTypes.asPointer(destructorValue_);
                return this.doIntrinsic(destructorValue__, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(destructorValue_);
        }

        private int executeAndSpecialize(Object destructorValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(destructorValue)) {
                    LLVMPointer destructorValue_ = LLVMTypes.asPointer(destructorValue);
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__ == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIntrinsic(destructorValue_, (LLVMContext)lLVMLanguageContextReference__.get());
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.destructor_}, new Object[]{destructorValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMPThreadKeyIntrinsics.LLVMPThreadKeyCreate create(LLVMExpressionNode destructor) {
            return new LLVMPThreadKeyCreateNodeGen(destructor);
        }
    }
}

