/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMPThreadStart;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMThreadException;
import com.oracle.truffle.llvm.runtime.pthread.PThreadExitException;

public final class LLVMPThreadThreadIntrinsics {

    public static abstract class LLVMPThreadSelf
    extends LLVMBuiltin {
        @Specialization
        protected LLVMNativePointer doIntrinsic() {
            return LLVMNativePointer.create(Thread.currentThread().getId());
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="threadId")
    public static abstract class LLVMPThreadJoin
    extends LLVMBuiltin {
        @Specialization
        protected Object doIntrinsic(long threadId, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            Thread thread = context.getpThreadContext().getThread(threadId);
            if (thread != null) {
                this.joinThread(thread);
            }
            return context.getpThreadContext().getThreadReturnValue(threadId);
        }

        @CompilerDirectives.TruffleBoundary
        private void joinThread(Thread thread) {
            assert (thread != null);
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMThreadException(this, "Failed to join thread", e);
            }
        }
    }

    @NodeChild(type=LLVMExpressionNode.class, value="retval")
    public static abstract class LLVMPThreadExit
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(Object returnValue, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            context.getpThreadContext().setThreadReturnValue(Thread.currentThread().getId(), returnValue);
            throw new PThreadExitException();
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="thread"), @NodeChild(type=LLVMExpressionNode.class, value="startRoutine"), @NodeChild(type=LLVMExpressionNode.class, value="arg")})
    @ImportStatic(value={CommonNodeFactory.class, LLVMInteropType.ValueKind.class})
    public static abstract class LLVMPThreadCreate
    extends LLVMBuiltin {
        @Specialization
        protected int doIntrinsic(LLVMPointer thread, LLVMPointer startRoutine, LLVMPointer arg, @Cached(value="createStoreNode(I64)") LLVMStoreNode store, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMPThreadStart.LLVMPThreadRunnable init = new LLVMPThreadStart.LLVMPThreadRunnable(startRoutine, arg, context, true);
            Thread t = context.getpThreadContext().createThread(init);
            if (t == null) {
                return 11;
            }
            store.executeWithTarget(thread, t.getId());
            t.start();
            return 0;
        }
    }
}

