/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMCompareExchangeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMCompareExchangeNode.class)
public final class LLVMCompareExchangeNodeGen
extends LLVMCompareExchangeNode {
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode comparisonValue_;
    @Node.Child
    private LLVMExpressionNode newValue_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMCompareExchangeNodeGen(AggregateType returnType, DataLayout dataLayout, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        super(returnType, dataLayout);
        this.address_ = address;
        this.comparisonValue_ = comparisonValue;
        this.newValue_ = newValue;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object comparisonValueValue_ = this.comparisonValue_.executeGeneric(frameValue);
        Object newValueValue_ = this.newValue_.executeGeneric(frameValue);
        if (state != 0 && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return this.doOp(frameValue, addressValue__, comparisonValueValue_, newValueValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, addressValue_, comparisonValueValue_, newValueValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object addressValue, Object comparisonValueValue, Object newValueValue) {
        int state = this.state_;
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            this.state_ = state |= 1;
            return this.doOp(frameValue, addressValue_, comparisonValueValue, newValueValue);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.comparisonValue_, this.newValue_}, new Object[]{addressValue, comparisonValueValue, newValueValue});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMCompareExchangeNode create(AggregateType returnType, DataLayout dataLayout, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) {
        return new LLVMCompareExchangeNodeGen(returnType, dataLayout, address, comparisonValue, newValue);
    }

    @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
    static final class LLVMCMPXCHInternalNodeGen
    extends LLVMCompareExchangeNode.LLVMCMPXCHInternalNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory op0_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory op1_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory op2_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory op3_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory op4_memory_;
        @Node.Child
        private Op5Data op5_cache;
        @Node.Child
        private Op6Data op6_cache;
        @Node.Child
        private Op7Data op7_cache;
        @Node.Child
        private Op8Data op8_cache;
        @Node.Child
        private Op9Data op9_cache;

        private LLVMCMPXCHInternalNodeGen(int resultSize, long secondValueOffset) {
            super(resultSize, secondValueOffset);
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            LLVMPointer arg0Value_;
            int state = this.state_;
            if ((state & 0x1F) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state & 1) != 0 && arg1Value instanceof Byte) {
                    byte by = (Byte)arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte by2 = (Byte)arg2Value;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, by, by2, this.op0_memory_);
                    }
                }
                if ((state & 2) != 0 && arg1Value instanceof Short) {
                    short s = (Short)arg1Value;
                    if (arg2Value instanceof Short) {
                        short s2 = (Short)arg2Value;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, s, s2, this.op1_memory_);
                    }
                }
                if ((state & 4) != 0 && arg1Value instanceof Integer) {
                    int n = (Integer)arg1Value;
                    if (arg2Value instanceof Integer) {
                        int n2 = (Integer)arg2Value;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, n, n2, this.op2_memory_);
                    }
                }
                if ((state & 8) != 0 && arg1Value instanceof Long) {
                    long l = (Long)arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, l, arg2Value_, this.op3_memory_);
                    }
                }
                if ((state & 0x10) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                    if (LLVMTypes.isNativePointer(arg2Value)) {
                        LLVMNativePointer lLVMNativePointer2 = LLVMTypes.asNativePointer(arg2Value);
                        return this.doOp(frameValue, (LLVMNativePointer)arg0Value_, lLVMNativePointer, lLVMNativePointer2, this.op4_memory_);
                    }
                }
            }
            if ((state & 0x3E0) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state & 0x20) != 0 && arg1Value instanceof Byte) {
                    byte by = (Byte)arg1Value;
                    if (arg2Value instanceof Byte) {
                        byte by3 = (Byte)arg2Value;
                        Op5Data s6_ = this.op5_cache;
                        if (s6_ != null) {
                            return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, by, by3, s6_.read_, s6_.write_, s6_.memory_);
                        }
                    }
                }
                if ((state & 0x40) != 0 && arg1Value instanceof Short) {
                    short s = (Short)arg1Value;
                    if (arg2Value instanceof Short) {
                        short s3 = (Short)arg2Value;
                        Op6Data s7_ = this.op6_cache;
                        if (s7_ != null) {
                            return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, s, s3, s7_.read_, s7_.write_, s7_.memory_);
                        }
                    }
                }
                if ((state & 0x80) != 0 && arg1Value instanceof Integer) {
                    int n = (Integer)arg1Value;
                    if (arg2Value instanceof Integer) {
                        int n3 = (Integer)arg2Value;
                        Op7Data s8_ = this.op7_cache;
                        if (s8_ != null) {
                            return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, n, n3, s8_.read_, s8_.write_, s8_.memory_);
                        }
                    }
                }
                if ((state & 0x100) != 0 && arg1Value instanceof Long) {
                    long l = (Long)arg1Value;
                    if (arg2Value instanceof Long) {
                        long arg2Value_2 = (Long)arg2Value;
                        Op8Data s9_ = this.op8_cache;
                        if (s9_ != null) {
                            return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_2, s9_.read_, s9_.write_, s9_.memory_);
                        }
                    }
                }
                if ((state & 0x200) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                    if (LLVMTypes.isNativePointer(arg2Value)) {
                        LLVMNativePointer lLVMNativePointer3 = LLVMTypes.asNativePointer(arg2Value);
                        Op9Data s10_ = this.op9_cache;
                        if (s10_ != null) {
                            return this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, lLVMNativePointer, lLVMNativePointer3, s10_.read_, s10_.write_, s10_.memory_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMPointer arg0Value_;
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg1Value instanceof Byte) {
                        byte by = (Byte)arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte arg2Value_ = (Byte)arg2Value;
                            this.op0_memory_ = LLVMNode.getLLVMMemory();
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, by, arg2Value_, this.op0_memory_);
                            return object;
                        }
                    }
                    if (arg1Value instanceof Short) {
                        short s = (Short)arg1Value;
                        if (arg2Value instanceof Short) {
                            short arg2Value_ = (Short)arg2Value;
                            this.op1_memory_ = LLVMNode.getLLVMMemory();
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, s, arg2Value_, this.op1_memory_);
                            return object;
                        }
                    }
                    if (arg1Value instanceof Integer) {
                        int n = (Integer)arg1Value;
                        if (arg2Value instanceof Integer) {
                            int arg2Value_ = (Integer)arg2Value;
                            this.op2_memory_ = LLVMNode.getLLVMMemory();
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, n, arg2Value_, this.op2_memory_);
                            return object;
                        }
                    }
                    if (arg1Value instanceof Long) {
                        long l = (Long)arg1Value;
                        if (arg2Value instanceof Long) {
                            long arg2Value_2 = (Long)arg2Value;
                            this.op3_memory_ = LLVMNode.getLLVMMemory();
                            this.state_ = state |= 8;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, l, arg2Value_2, this.op3_memory_);
                            return object;
                        }
                    }
                    if (LLVMTypes.isNativePointer(arg1Value)) {
                        LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                        if (LLVMTypes.isNativePointer(arg2Value)) {
                            LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                            this.op4_memory_ = LLVMNode.getLLVMMemory();
                            this.state_ = state |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            Object arg2Value_2 = this.doOp(frameValue, (LLVMNativePointer)arg0Value_, lLVMNativePointer, arg2Value_, this.op4_memory_);
                            return arg2Value_2;
                        }
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if (arg1Value instanceof Byte) {
                        byte by = (Byte)arg1Value;
                        if (arg2Value instanceof Byte) {
                            byte arg2Value_ = (Byte)arg2Value;
                            Op5Data s6_ = (Op5Data)super.insert((Node)new Op5Data());
                            s6_.read_ = s6_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI8Read());
                            s6_.write_ = s6_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI8Write());
                            s6_.memory_ = LLVMNode.getLLVMMemory();
                            this.op5_cache = s6_;
                            this.state_ = state |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, by, arg2Value_, s6_.read_, s6_.write_, s6_.memory_);
                            return object;
                        }
                    }
                    if (arg1Value instanceof Short) {
                        short s = (Short)arg1Value;
                        if (arg2Value instanceof Short) {
                            short arg2Value_ = (Short)arg2Value;
                            Op6Data s7_ = (Op6Data)super.insert((Node)new Op6Data());
                            s7_.read_ = s7_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI16Read());
                            s7_.write_ = s7_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI16Write());
                            s7_.memory_ = LLVMNode.getLLVMMemory();
                            this.op6_cache = s7_;
                            this.state_ = state |= 0x40;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, s, arg2Value_, s7_.read_, s7_.write_, s7_.memory_);
                            return object;
                        }
                    }
                    if (arg1Value instanceof Integer) {
                        int n = (Integer)arg1Value;
                        if (arg2Value instanceof Integer) {
                            int arg2Value_ = (Integer)arg2Value;
                            Op7Data s8_ = (Op7Data)super.insert((Node)new Op7Data());
                            s8_.read_ = s8_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI32Read());
                            s8_.write_ = s8_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI32Write());
                            s8_.memory_ = LLVMNode.getLLVMMemory();
                            this.op7_cache = s8_;
                            this.state_ = state |= 0x80;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, n, arg2Value_, s8_.read_, s8_.write_, s8_.memory_);
                            return object;
                        }
                    }
                    if (arg1Value instanceof Long) {
                        long l = (Long)arg1Value;
                        if (arg2Value instanceof Long) {
                            long arg2Value_ = (Long)arg2Value;
                            Op8Data s9_ = (Op8Data)super.insert((Node)new Op8Data());
                            s9_.read_ = s9_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Read());
                            s9_.write_ = s9_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Write());
                            s9_.memory_ = LLVMNode.getLLVMMemory();
                            this.op8_cache = s9_;
                            this.state_ = state |= 0x100;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, l, arg2Value_, s9_.read_, s9_.write_, s9_.memory_);
                            return object;
                        }
                    }
                    if (LLVMTypes.isNativePointer(arg1Value)) {
                        LLVMNativePointer lLVMNativePointer = LLVMTypes.asNativePointer(arg1Value);
                        if (LLVMTypes.isNativePointer(arg2Value)) {
                            LLVMNativePointer arg2Value_ = LLVMTypes.asNativePointer(arg2Value);
                            Op9Data s10_ = (Op9Data)super.insert((Node)new Op9Data());
                            s10_.read_ = s10_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Read());
                            s10_.write_ = s10_.insertAccessor(LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.createI64Write());
                            s10_.memory_ = LLVMNode.getLLVMMemory();
                            this.op9_cache = s10_;
                            this.state_ = state |= 0x200;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doOp(frameValue, (LLVMManagedPointer)arg0Value_, lLVMNativePointer, arg2Value_, s10_.read_, s10_.write_, s10_.memory_);
                            return object;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMCompareExchangeNode.LLVMCMPXCHInternalNode create(int resultSize, long secondValueOffset) {
            return new LLVMCMPXCHInternalNodeGen(resultSize, secondValueOffset);
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        private static final class Op9Data
        extends Node {
            @Node.Child
            LLVMI64LoadNode read_;
            @Node.Child
            LLVMI64StoreNode write_;
            @CompilerDirectives.CompilationFinal
            LLVMMemory memory_;

            Op9Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        private static final class Op8Data
        extends Node {
            @Node.Child
            LLVMI64LoadNode read_;
            @Node.Child
            LLVMI64StoreNode write_;
            @CompilerDirectives.CompilationFinal
            LLVMMemory memory_;

            Op8Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        private static final class Op7Data
        extends Node {
            @Node.Child
            LLVMI32LoadNode read_;
            @Node.Child
            LLVMI32StoreNode write_;
            @CompilerDirectives.CompilationFinal
            LLVMMemory memory_;

            Op7Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        private static final class Op6Data
        extends Node {
            @Node.Child
            LLVMI16LoadNode read_;
            @Node.Child
            LLVMI16StoreNode write_;
            @CompilerDirectives.CompilationFinal
            LLVMMemory memory_;

            Op6Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMCompareExchangeNode.LLVMCMPXCHInternalNode.class)
        private static final class Op5Data
        extends Node {
            @Node.Child
            LLVMI8LoadNode read_;
            @Node.Child
            LLVMI8StoreNode write_;
            @CompilerDirectives.CompilationFinal
            LLVMMemory memory_;

            Op5Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

