/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.NodeFields;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.interop.LLVMNegatedForeignObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
@NodeFields(value={@NodeField(type=long.class, name="typeWidth"), @NodeField(type=Type.class, name="targetType")})
public abstract class LLVMGetElementPtrNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMIncrementPointerNode incrementNode = LLVMGetElementPtrNodeGen.LLVMIncrementPointerNodeGen.create();

    public abstract long getTypeWidth();

    public abstract Type getTargetType();

    @Specialization
    protected LLVMPointer longIncrement(LLVMPointer addr, long val) {
        long incr = this.getTypeWidth() * val;
        return this.incrementNode.executeWithTarget(addr, incr);
    }

    @Specialization
    protected LLVMPointer longIncrement(LLVMPointer addr, LLVMNativePointer val) {
        long incr = this.getTypeWidth() * val.asNative();
        return this.incrementNode.executeWithTarget(addr, incr);
    }

    @Specialization
    protected LLVMPointer intIncrement(LLVMPointer addr, int val) {
        long incr = this.getTypeWidth() * (long)val;
        return this.incrementNode.executeWithTarget(addr, incr);
    }

    protected static boolean isNegated(Object obj, Object negatedObj) {
        if (negatedObj instanceof LLVMNegatedForeignObject) {
            return ((LLVMNegatedForeignObject)negatedObj).getForeign() == obj;
        }
        return false;
    }

    @Specialization(guards={"isNegated(addr.getObject(), val.getObject())"})
    protected LLVMPointer pointerDiff(LLVMManagedPointer addr, LLVMManagedPointer val) {
        return LLVMNativePointer.create(addr.getOffset() + val.getOffset());
    }

    @Specialization(guards={"isNegated(val.getObject(), addr.getObject())"})
    protected LLVMPointer pointerDiffRev(LLVMManagedPointer addr, LLVMManagedPointer val) {
        return LLVMNativePointer.create(val.getOffset() + addr.getOffset());
    }

    @Specialization
    protected LLVMPointerVector doPointer(LLVMPointerVector val1, LLVMI64Vector val2) {
        LLVMPointer[] result = new LLVMPointer[val1.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.longIncrement(val1.getValue(i), val2.getValue(i));
        }
        return LLVMPointerVector.create(result);
    }

    public static abstract class LLVMIncrementPointerNode
    extends LLVMNode {
        public abstract LLVMPointer executeWithTarget(LLVMPointer var1, int var2);

        public abstract LLVMPointer executeWithTarget(LLVMPointer var1, long var2);

        public abstract LLVMPointer executeWithTarget(LLVMPointer var1, Object var2);

        @Specialization
        protected LLVMPointer doPointer(LLVMPointer addr, int incr) {
            return addr.increment(incr);
        }

        @Specialization
        protected LLVMPointer doPointer(LLVMPointer addr, long incr) {
            return addr.increment(incr);
        }
    }
}

