/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GeneratedBy(value=LLVMGetElementPtrNode.class)
public final class LLVMGetElementPtrNodeGen
extends LLVMGetElementPtrNode {
    private final long typeWidth;
    private final Type targetType;
    @Node.Child
    private LLVMExpressionNode child0_;
    @Node.Child
    private LLVMExpressionNode child1_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMGetElementPtrNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1, long typeWidth, Type targetType) {
        this.typeWidth = typeWidth;
        this.targetType = targetType;
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public long getTypeWidth() {
        return this.typeWidth;
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x3E) == 0 && state != 0) {
            return this.executeGeneric_long0(frameValue, state);
        }
        if ((state & 0x3B) == 0 && state != 0) {
            return this.executeGeneric_int1(frameValue, state);
        }
        return this.executeGeneric_generic2(frameValue, state);
    }

    private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
        long child1Value_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        try {
            child1Value_ = this.child1_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(child0Value_, ex.getResult());
        }
        assert ((state & 1) != 0);
        if (LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            return this.longIncrement(child0Value__, child1Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    private Object executeGeneric_int1(VirtualFrame frameValue, int state) {
        int child1Value_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        try {
            child1Value_ = this.child1_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(child0Value_, ex.getResult());
        }
        assert ((state & 4) != 0);
        if (LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            return this.intIncrement(child0Value__, child1Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
        Object child1Value__;
        Object child0Value__;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if ((state & 7) != 0 && LLVMTypes.isPointer(child0Value_)) {
            child0Value__ = LLVMTypes.asPointer(child0Value_);
            if ((state & 1) != 0 && child1Value_ instanceof Long) {
                long child1Value__2 = (Long)child1Value_;
                return this.longIncrement((LLVMPointer)child0Value__, child1Value__2);
            }
            if ((state & 2) != 0 && LLVMTypes.isNativePointer(child1Value_)) {
                LLVMNativePointer child1Value__3 = LLVMTypes.asNativePointer(child1Value_);
                return this.longIncrement((LLVMPointer)child0Value__, child1Value__3);
            }
            if ((state & 4) != 0 && child1Value_ instanceof Integer) {
                int child1Value__4 = (Integer)child1Value_;
                return this.intIncrement((LLVMPointer)child0Value__, child1Value__4);
            }
        }
        if ((state & 0x18) != 0 && LLVMTypes.isManagedPointer(child0Value_)) {
            child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
            if (LLVMTypes.isManagedPointer(child1Value_)) {
                child1Value__ = LLVMTypes.asManagedPointer(child1Value_);
                if ((state & 8) != 0 && LLVMGetElementPtrNode.isNegated(child0Value__.getObject(), child1Value__.getObject())) {
                    return this.pointerDiff((LLVMManagedPointer)child0Value__, (LLVMManagedPointer)child1Value__);
                }
                if ((state & 0x10) != 0 && LLVMGetElementPtrNode.isNegated(child1Value__.getObject(), child0Value__.getObject())) {
                    return this.pointerDiffRev((LLVMManagedPointer)child0Value__, (LLVMManagedPointer)child1Value__);
                }
            }
        }
        if ((state & 0x20) != 0 && child0Value_ instanceof LLVMPointerVector) {
            child0Value__ = (LLVMPointerVector)child0Value_;
            if (child1Value_ instanceof LLVMI64Vector) {
                child1Value__ = (LLVMI64Vector)child1Value_;
                return this.doPointer((LLVMPointerVector)child0Value__, (LLVMI64Vector)child1Value__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    private Object executeAndSpecialize(Object child0Value, Object child1Value) {
        Object child1Value_;
        Object child0Value_;
        int state = this.state_;
        if (LLVMTypes.isPointer(child0Value)) {
            child0Value_ = LLVMTypes.asPointer(child0Value);
            if (child1Value instanceof Long) {
                long child1Value_2 = (Long)child1Value;
                this.state_ = state |= 1;
                return this.longIncrement((LLVMPointer)child0Value_, child1Value_2);
            }
            if (LLVMTypes.isNativePointer(child1Value)) {
                LLVMNativePointer child1Value_3 = LLVMTypes.asNativePointer(child1Value);
                this.state_ = state |= 2;
                return this.longIncrement((LLVMPointer)child0Value_, child1Value_3);
            }
            if (child1Value instanceof Integer) {
                int child1Value_4 = (Integer)child1Value;
                this.state_ = state |= 4;
                return this.intIncrement((LLVMPointer)child0Value_, child1Value_4);
            }
        }
        if (LLVMTypes.isManagedPointer(child0Value)) {
            child0Value_ = LLVMTypes.asManagedPointer(child0Value);
            if (LLVMTypes.isManagedPointer(child1Value)) {
                child1Value_ = LLVMTypes.asManagedPointer(child1Value);
                if (LLVMGetElementPtrNode.isNegated(child0Value_.getObject(), child1Value_.getObject())) {
                    this.state_ = state |= 8;
                    return this.pointerDiff((LLVMManagedPointer)child0Value_, (LLVMManagedPointer)child1Value_);
                }
                if (LLVMGetElementPtrNode.isNegated(child1Value_.getObject(), child0Value_.getObject())) {
                    this.state_ = state |= 0x10;
                    return this.pointerDiffRev((LLVMManagedPointer)child0Value_, (LLVMManagedPointer)child1Value_);
                }
            }
        }
        if (child0Value instanceof LLVMPointerVector) {
            child0Value_ = (LLVMPointerVector)child0Value;
            if (child1Value instanceof LLVMI64Vector) {
                child1Value_ = (LLVMI64Vector)child1Value;
                this.state_ = state |= 0x20;
                return this.doPointer((LLVMPointerVector)child0Value_, (LLVMI64Vector)child1Value_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMGetElementPtrNode create(LLVMExpressionNode child0, LLVMExpressionNode child1, long typeWidth, Type targetType) {
        return new LLVMGetElementPtrNodeGen(child0, child1, typeWidth, targetType);
    }

    @GeneratedBy(value=LLVMGetElementPtrNode.LLVMIncrementPointerNode.class)
    public static final class LLVMIncrementPointerNodeGen
    extends LLVMGetElementPtrNode.LLVMIncrementPointerNode {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMIncrementPointerNodeGen() {
        }

        @Override
        public LLVMPointer executeWithTarget(LLVMPointer arg0Value, Object arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return this.doPointer(arg0Value, arg1Value_);
                }
                if ((state & 2) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    return this.doPointer(arg0Value, arg1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public LLVMPointer executeWithTarget(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if ((state & 1) != 0) {
                return this.doPointer(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public LLVMPointer executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
            int state = this.state_;
            if ((state & 2) != 0) {
                return this.doPointer(arg0Value, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMPointer executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value) {
            int state = this.state_;
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_ = state |= 1;
                return this.doPointer(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (Long)arg1Value;
                this.state_ = state |= 2;
                return this.doPointer(arg0Value, arg1Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMGetElementPtrNode.LLVMIncrementPointerNode create() {
            return new LLVMIncrementPointerNodeGen();
        }
    }
}

