/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetStackSpaceInstruction;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMGetStackSpaceInstruction.class)
public final class LLVMGetStackSpaceInstructionFactory {

    @GeneratedBy(value=LLVMGetStackSpaceInstruction.LLVMAllocaInstruction.class)
    public static final class LLVMAllocaInstructionNodeGen
    extends LLVMGetStackSpaceInstruction.LLVMAllocaInstruction {
        private final int size;
        private final int alignment;
        private final Type symbolType;
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory op0_memory_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory op1_memory_;

        private LLVMAllocaInstructionNodeGen(LLVMExpressionNode child0, int size, int alignment, Type symbolType) {
            this.size = size;
            this.alignment = alignment;
            this.symbolType = symbolType;
            this.child0_ = child0;
        }

        @Override
        int getSize() {
            return this.size;
        }

        @Override
        int getAlignment() {
            return this.alignment;
        }

        @Override
        Type getSymbolType() {
            return this.symbolType;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 2) == 0 && state != 0) {
                return this.executeGeneric_int0(frameValue, state);
            }
            if ((state & 1) == 0 && state != 0) {
                return this.executeGeneric_long1(frameValue, state);
            }
            return this.executeGeneric_generic2(frameValue, state);
        }

        private Object executeGeneric_int0(VirtualFrame frameValue, int state) {
            int child0Value_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doOp(frameValue, child0Value_, this.op0_memory_);
        }

        private Object executeGeneric_long1(VirtualFrame frameValue, int state) {
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doOp(frameValue, child0Value_, this.op1_memory_);
        }

        private Object executeGeneric_generic2(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Integer) {
                int child0Value__ = (Integer)child0Value_;
                return this.doOp(frameValue, child0Value__, this.op0_memory_);
            }
            if ((state & 2) != 0 && child0Value_ instanceof Long) {
                long child0Value__ = (Long)child0Value_;
                return this.doOp(frameValue, child0Value__, this.op1_memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, child0Value_);
        }

        private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue, Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (child0Value instanceof Integer) {
                    int child0Value_ = (Integer)child0Value;
                    this.op0_memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doOp(frameValue, child0Value_, this.op0_memory_);
                    return lLVMNativePointer;
                }
                if (child0Value instanceof Long) {
                    long child0Value_ = (Long)child0Value;
                    this.op1_memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doOp(frameValue, child0Value_, this.op1_memory_);
                    return lLVMNativePointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMGetStackSpaceInstruction.LLVMAllocaInstruction create(LLVMExpressionNode child0, int size, int alignment, Type symbolType) {
            return new LLVMAllocaInstructionNodeGen(child0, size, alignment, symbolType);
        }
    }

    @GeneratedBy(value=LLVMGetStackSpaceInstruction.LLVMGetUniqueStackSpaceInstruction.class)
    public static final class LLVMGetUniqueStackSpaceInstructionNodeGen
    extends LLVMGetStackSpaceInstruction.LLVMGetUniqueStackSpaceInstruction {
        private final int size;
        private final int alignment;
        private final Type symbolType;
        private final LLVMStack.UniquesRegion.UniqueSlot uniqueSlot;

        private LLVMGetUniqueStackSpaceInstructionNodeGen(int size, int alignment, Type symbolType, LLVMStack.UniquesRegion.UniqueSlot uniqueSlot) {
            this.size = size;
            this.alignment = alignment;
            this.symbolType = symbolType;
            this.uniqueSlot = uniqueSlot;
        }

        @Override
        int getSize() {
            return this.size;
        }

        @Override
        int getAlignment() {
            return this.alignment;
        }

        @Override
        Type getSymbolType() {
            return this.symbolType;
        }

        @Override
        LLVMStack.UniquesRegion.UniqueSlot getUniqueSlot() {
            return this.uniqueSlot;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doOp(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMGetStackSpaceInstruction.LLVMGetUniqueStackSpaceInstruction create(int size, int alignment, Type symbolType, LLVMStack.UniquesRegion.UniqueSlot uniqueSlot) {
            return new LLVMGetUniqueStackSpaceInstructionNodeGen(size, alignment, symbolType, uniqueSlot);
        }
    }

    @GeneratedBy(value=LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction.class)
    public static final class LLVMAllocaConstInstructionNodeGen
    extends LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction {
        private final int size;
        private final int alignment;
        private final Type symbolType;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMAllocaConstInstructionNodeGen(int size, int alignment, Type symbolType) {
            this.size = size;
            this.alignment = alignment;
            this.symbolType = symbolType;
        }

        @Override
        int getSize() {
            return this.size;
        }

        @Override
        int getAlignment() {
            return this.alignment;
        }

        @Override
        Type getSymbolType() {
            return this.symbolType;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if (state != 0) {
                return this.doOp(frameValue, this.memory_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMNativePointer lLVMNativePointer = this.doOp(frameValue, this.memory_);
                return lLVMNativePointer;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction create(int size, int alignment, Type symbolType) {
            return new LLVMAllocaConstInstructionNodeGen(size, alignment, symbolType);
        }
    }
}

