/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(value="address", type=LLVMExpressionNode.class)
public abstract class LLVMStructArrayLiteralNode
extends LLVMExpressionNode {
    @Node.Children
    private final LLVMExpressionNode[] values;
    private final long stride;
    @Node.Child
    private LLVMMemMoveNode memMove;

    public LLVMStructArrayLiteralNode(LLVMExpressionNode[] values, LLVMMemMoveNode memMove, long stride) {
        this.values = values;
        this.stride = stride;
        this.memMove = memMove;
    }

    @ExplodeLoop
    @Specialization
    protected LLVMNativePointer writeDouble(VirtualFrame frame, LLVMNativePointer addr) {
        long currentPtr = addr.asNative();
        for (int i = 0; i < this.values.length; ++i) {
            try {
                LLVMNativePointer currentValue = this.values[i].executeLLVMNativePointer(frame);
                this.memMove.executeWithTarget(LLVMNativePointer.create(currentPtr), currentValue, this.stride);
                currentPtr += this.stride;
                continue;
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }
        return addr;
    }

    protected boolean noOffset(LLVMManagedPointer o) {
        return o.getOffset() == 0L;
    }

    @ExplodeLoop
    @Specialization(guards={"noOffset(addr)"})
    protected Object doVoid(VirtualFrame frame, LLVMManagedPointer addr) {
        LLVMManagedPointer currentPtr = addr;
        for (int i = 0; i < this.values.length; ++i) {
            Object currentValue = this.values[i].executeGeneric(frame);
            this.memMove.executeWithTarget(currentPtr, currentValue, this.stride);
            currentPtr = currentPtr.increment(this.stride);
        }
        return addr;
    }
}

