/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMAbstractLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMI32LoadNode
extends LLVMAbstractLoadNode {
    private final IntValueProfile profile = IntValueProfile.createIdentityProfile();

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected int doI32Native(LLVMNativePointer addr) {
        return this.profile.profile(this.getLLVMMemoryCached().getI32(addr));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected int doI32DerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doI32Managed(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected int doI32Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI32(addr.getObject(), addr.getOffset());
    }
}

