/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.ByteValueProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMAbstractLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMI8LoadNode
extends LLVMAbstractLoadNode {
    private final ByteValueProfile profile = ByteValueProfile.createIdentityProfile();

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected byte doI8Native(LLVMNativePointer addr) {
        return this.profile.profile(this.getLLVMMemoryCached().getI8(addr));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected byte doI8DerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doI8Managed(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected byte doI8Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI8(addr.getObject(), addr.getOffset());
    }
}

