/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMLoadVectorNode.class)
public final class LLVMLoadVectorNodeFactory {
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.class)
    public static final class LLVMLoadDoubleVectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadDoubleVectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadDoubleVectorNode doubleVector_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadDoubleVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doDoubleVectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doDoubleVector((LLVMNativePointer)addressValue_, this.doubleVector_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMDoubleVector lLVMDoubleVector = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMDoubleVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMDoubleVector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMDoubleVector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMDoubleVector lLVMDoubleVector = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMDoubleVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doDoubleVectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doDoubleVector((LLVMNativePointer)addressValue__, this.doubleVector_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMDoubleVector lLVMDoubleVector = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMDoubleVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMDoubleVector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMDoubleVector lLVMDoubleVector = this.doDoubleVectorNative((LLVMNativePointer)addressValue_);
                        return lLVMDoubleVector;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.doubleVector_load_ = (LLVMLoadVectorNode.LLVMLoadDoubleVectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMDoubleVector lLVMDoubleVector = this.doDoubleVector((LLVMNativePointer)addressValue_, this.doubleVector_load_);
                        return lLVMDoubleVector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMDoubleVector lLVMDoubleVector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMDoubleVector;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMDoubleVector lLVMDoubleVector = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMDoubleVector;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadDoubleVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadDoubleVectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadDoubleVectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadFloatVectorNode.class)
    public static final class LLVMLoadFloatVectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadFloatVectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadFloatVectorNode floatVectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadFloatVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doFloatVectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doFloatVectorDerefHandle((LLVMNativePointer)addressValue_, this.floatVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMFloatVector lLVMFloatVector = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMFloatVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMFloatVector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMFloatVector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMFloatVector lLVMFloatVector = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMFloatVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doFloatVectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doFloatVectorDerefHandle((LLVMNativePointer)addressValue__, this.floatVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMFloatVector lLVMFloatVector = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMFloatVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMFloatVector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMFloatVector lLVMFloatVector = this.doFloatVectorNative((LLVMNativePointer)addressValue_);
                        return lLVMFloatVector;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.floatVectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadFloatVectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMFloatVector lLVMFloatVector = this.doFloatVectorDerefHandle((LLVMNativePointer)addressValue_, this.floatVectorDerefHandle_load_);
                        return lLVMFloatVector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMFloatVector lLVMFloatVector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMFloatVector;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMFloatVector lLVMFloatVector = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMFloatVector;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadFloatVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadFloatVectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadFloatVectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadPointerVectorNode.class)
    public static final class LLVMLoadPointerVectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadPointerVectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadPointerVectorNode pointerVectorDerefHandle_load_;
        @Node.Child
        private ForeignPointers0Data foreignPointers0_cache;

        private LLVMLoadPointerVectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doPointerVectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doPointerVectorDerefHandle((LLVMNativePointer)addressValue_, this.pointerVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeignPointers((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreignPointers1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreignPointers1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMPointerVector lLVMPointerVector = this.doForeignPointers(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMPointerVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMPointerVector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeignPointers(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreignPointers1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMPointerVector foreignPointers1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMPointerVector lLVMPointerVector = this.doForeignPointers(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMPointerVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doPointerVectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doPointerVectorDerefHandle((LLVMNativePointer)addressValue__, this.pointerVectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeignPointers((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreignPointers1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreignPointers1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMPointerVector lLVMPointerVector = this.doForeignPointers(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMPointerVector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMPointerVector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointerVector lLVMPointerVector = this.doPointerVectorNative((LLVMNativePointer)addressValue_);
                        return lLVMPointerVector;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.pointerVectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadPointerVectorNode)super.insert((Node)LLVMLoadVectorNode.LLVMLoadPointerVectorNode.create(this.getVectorLength()));
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointerVector lLVMPointerVector = this.doPointerVectorDerefHandle((LLVMNativePointer)addressValue_, this.pointerVectorDerefHandle_load_);
                        return lLVMPointerVector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        ForeignPointers0Data s3_ = this.foreignPointers0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (ForeignPointers0Data)super.insert((Node)new ForeignPointers0Data(this.foreignPointers0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreignPointers0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMPointerVector lLVMPointerVector = this.doForeignPointers((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMPointerVector;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreignPointers0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMPointerVector lLVMPointerVector = this.doForeignPointers((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMPointerVector;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            ForeignPointers0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreignPointers0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadPointerVectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadPointerVectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadPointerVectorNode.class)
        private static final class ForeignPointers0Data
        extends Node {
            @Node.Child
            ForeignPointers0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            ForeignPointers0Data(ForeignPointers0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI64VectorNode.class)
    public static final class LLVMLoadI64VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI64VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI64VectorNode i64VectorDerefHandle_load_;
        @Node.Child
        private I64Vector0Data i64Vector0_cache;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadPointerVectorNode pointerVector_load_;

        private LLVMLoadI64VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI64VectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI64VectorDerefHandle((LLVMNativePointer)addressValue_, this.i64VectorDerefHandle_load_);
                }
            }
            if ((state & 0x1C) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    I64Vector0Data s3_ = this.i64Vector0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            try {
                                return this.doI64Vector((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            }
                            catch (UnexpectedResultException ex) {
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 3;
                                    this.state_ &= 0xFFFFFFF3;
                                    this.i64Vector0_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.i64Vector1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
                if ((state & 0x10) != 0) {
                    return this.doPointerVector((LLVMManagedPointer)addressValue_, this.pointerVector_load_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i64Vector1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI64Vector lLVMI64Vector = this.doI64Vector(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMI64Vector;
            }
            catch (UnexpectedResultException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 2;
                    this.state_ &= 0xFFFFFFF7;
                }
                finally {
                    lock.unlock();
                }
                Object object = ex.getResult();
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected Object executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0x1C) != 0) {
                if ((state & 4) != 0) {
                    I64Vector0Data s3_ = this.i64Vector0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            try {
                                return this.doI64Vector(addressValue, s3_.nativeRead_);
                            }
                            catch (UnexpectedResultException ex) {
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 3;
                                    this.state_ &= 0xFFFFFFF3;
                                    this.i64Vector0_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.i64Vector1Boundary0(state, addressValue);
                }
                if ((state & 0x10) != 0) {
                    return this.doPointerVector(addressValue, this.pointerVector_load_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i64Vector1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI64Vector lLVMI64Vector = this.doI64Vector(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMI64Vector;
            }
            catch (UnexpectedResultException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 2;
                    this.state_ &= 0xFFFFFFF7;
                }
                finally {
                    lock.unlock();
                }
                Object object = ex.getResult();
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI64VectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI64VectorDerefHandle((LLVMNativePointer)addressValue__, this.i64VectorDerefHandle_load_);
                }
            }
            if ((state & 0x1C) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    I64Vector0Data s3_ = this.i64Vector0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            try {
                                return this.doI64Vector((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                            }
                            catch (UnexpectedResultException ex) {
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 3;
                                    this.state_ &= 0xFFFFFFF3;
                                    this.i64Vector0_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return ex.getResult();
                            }
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.i64Vector1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
                if ((state & 0x10) != 0) {
                    return this.doPointerVector((LLVMManagedPointer)addressValue__, this.pointerVector_load_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i64Vector1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI64Vector lLVMI64Vector = this.doI64Vector(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMI64Vector;
            }
            catch (UnexpectedResultException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 2;
                    this.state_ &= 0xFFFFFFF7;
                }
                finally {
                    lock.unlock();
                }
                Object object = ex.getResult();
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * Exception decompiling
         */
        private Object executeAndSpecialize(Object addressValue) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 36[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public NodeCost getCost() {
            I64Vector0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.i64Vector0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI64VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI64VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI64VectorNode.class)
        private static final class I64Vector0Data
        extends Node {
            @Node.Child
            I64Vector0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            I64Vector0Data(I64Vector0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI32VectorNode.class)
    public static final class LLVMLoadI32VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI32VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI32VectorNode i32VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI32VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI32VectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI32VectorDerefHandle((LLVMNativePointer)addressValue_, this.i32VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI32Vector lLVMI32Vector = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMI32Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMI32Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI32Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI32Vector lLVMI32Vector = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMI32Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI32VectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI32VectorDerefHandle((LLVMNativePointer)addressValue__, this.i32VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI32Vector lLVMI32Vector = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMI32Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI32Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI32Vector lLVMI32Vector = this.doI32VectorNative((LLVMNativePointer)addressValue_);
                        return lLVMI32Vector;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.i32VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI32VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI32Vector lLVMI32Vector = this.doI32VectorDerefHandle((LLVMNativePointer)addressValue_, this.i32VectorDerefHandle_load_);
                        return lLVMI32Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI32Vector lLVMI32Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI32Vector;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI32Vector lLVMI32Vector = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMI32Vector;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI32VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI32VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI32VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI16VectorNode.class)
    public static final class LLVMLoadI16VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI16VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI16VectorNode i16VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI16VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI16VectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI16VectorDerefHandle((LLVMNativePointer)addressValue_, this.i16VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI16Vector lLVMI16Vector = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMI16Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMI16Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI16Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI16Vector lLVMI16Vector = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMI16Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI16VectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI16VectorDerefHandle((LLVMNativePointer)addressValue__, this.i16VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI16Vector lLVMI16Vector = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMI16Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI16Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI16Vector lLVMI16Vector = this.doI16VectorNative((LLVMNativePointer)addressValue_);
                        return lLVMI16Vector;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.i16VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI16VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI16Vector lLVMI16Vector = this.doI16VectorDerefHandle((LLVMNativePointer)addressValue_, this.i16VectorDerefHandle_load_);
                        return lLVMI16Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI16Vector lLVMI16Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI16Vector;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI16Vector lLVMI16Vector = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMI16Vector;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI16VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI16VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI16VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI8VectorNode.class)
    public static final class LLVMLoadI8VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI8VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI8VectorNode i8VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI8VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI8VectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI8VectorDerefHandle((LLVMNativePointer)addressValue_, this.i8VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI8Vector lLVMI8Vector = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMI8Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMI8Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI8Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI8Vector lLVMI8Vector = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMI8Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI8VectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI8VectorDerefHandle((LLVMNativePointer)addressValue__, this.i8VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI8Vector lLVMI8Vector = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMI8Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI8Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI8Vector lLVMI8Vector = this.doI8VectorNative((LLVMNativePointer)addressValue_);
                        return lLVMI8Vector;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.i8VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI8VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI8Vector lLVMI8Vector = this.doI8VectorDerefHandle((LLVMNativePointer)addressValue_, this.i8VectorDerefHandle_load_);
                        return lLVMI8Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI8Vector lLVMI8Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI8Vector;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI8Vector lLVMI8Vector = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMI8Vector;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI8VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI8VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI8VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI1VectorNode.class)
    public static final class LLVMLoadI1VectorNodeGen
    extends LLVMLoadVectorNode.LLVMLoadI1VectorNode {
        private final int vectorLength;
        @Node.Child
        private LLVMExpressionNode address_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private LLVMLoadVectorNode.LLVMLoadI1VectorNode i1VectorDerefHandle_load_;
        @Node.Child
        private Foreign0Data foreign0_cache;

        private LLVMLoadI1VectorNodeGen(LLVMExpressionNode address, int vectorLength) {
            this.vectorLength = vectorLength;
            this.address_ = address;
        }

        @Override
        public int getVectorLength() {
            return this.vectorLength;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithTarget(Object addressValue) {
            LLVMPointer addressValue_;
            int state = this.state_;
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI1VectorNative((LLVMNativePointer)addressValue_);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    return this.doI1VectorDerefHandle((LLVMNativePointer)addressValue_, this.i1VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue_.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary(state, (LLVMManagedPointer)addressValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary(int state, LLVMManagedPointer addressValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI1Vector lLVMI1Vector = this.doForeign(addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return lLVMI1Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected LLVMI1Vector executeManaged(LLVMManagedPointer addressValue) {
            int state = this.state_;
            if ((state & 0xC) != 0) {
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue.getObject())) {
                            return this.doForeign(addressValue, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary0(state, addressValue);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMI1Vector foreign1Boundary0(int state, LLVMManagedPointer addressValue) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI1Vector lLVMI1Vector = this.doForeign(addressValue, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue.getObject()));
                return lLVMI1Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            LLVMPointer addressValue__;
            int state = this.state_;
            Object addressValue_ = this.address_.executeGeneric(frameValue);
            if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI1VectorNative((LLVMNativePointer)addressValue__);
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    return this.doI1VectorDerefHandle((LLVMNativePointer)addressValue__, this.i1VectorDerefHandle_load_);
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 4) != 0) {
                    Foreign0Data s3_ = this.foreign0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeRead_.accepts(addressValue__.getObject())) {
                            return this.doForeign((LLVMManagedPointer)addressValue__, s3_.nativeRead_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0) {
                    return this.foreign1Boundary1(state, (LLVMManagedPointer)addressValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(addressValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object foreign1Boundary1(int state, LLVMManagedPointer addressValue__) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMI1Vector lLVMI1Vector = this.doForeign(addressValue__, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return lLVMI1Vector;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMI1Vector executeAndSpecialize(Object addressValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                LLVMPointer addressValue_;
                if (LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_ = LLVMTypes.asNativePointer(addressValue);
                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMI1Vector lLVMI1Vector = this.doI1VectorNative((LLVMNativePointer)addressValue_);
                        return lLVMI1Vector;
                    }
                    if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                        this.i1VectorDerefHandle_load_ = (LLVMLoadVectorNode.LLVMLoadI1VectorNode)super.insert((Node)this.createRecursive());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMI1Vector lLVMI1Vector = this.doI1VectorDerefHandle((LLVMNativePointer)addressValue_, this.i1VectorDerefHandle_load_);
                        return lLVMI1Vector;
                    }
                }
                if (LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                    if (exclude == 0) {
                        int count3_ = 0;
                        Foreign0Data s3_ = this.foreign0_cache;
                        if ((state & 4) != 0) {
                            while (s3_ != null && !s3_.nativeRead_.accepts(addressValue_.getObject())) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && count3_ < 3) {
                            s3_ = (Foreign0Data)super.insert((Node)new Foreign0Data(this.foreign0_cache));
                            s3_.nativeRead_ = (LLVMManagedReadLibrary)s3_.insertAccessor(L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject()));
                            this.foreign0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            LLVMI1Vector lLVMI1Vector = this.doForeign((LLVMManagedPointer)addressValue_, s3_.nativeRead_);
                            return lLVMI1Vector;
                        }
                    }
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        this.exclude_ = exclude |= 1;
                        this.foreign0_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        LLVMI1Vector lLVMI1Vector = this.doForeign((LLVMManagedPointer)addressValue_, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        return lLVMI1Vector;
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Foreign0Data s3_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s3_ = this.foreign0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMLoadVectorNode.LLVMLoadI1VectorNode create(LLVMExpressionNode address, int vectorLength) {
            return new LLVMLoadI1VectorNodeGen(address, vectorLength);
        }

        @GeneratedBy(value=LLVMLoadVectorNode.LLVMLoadI1VectorNode.class)
        private static final class Foreign0Data
        extends Node {
            @Node.Child
            Foreign0Data next_;
            @Node.Child
            LLVMManagedReadLibrary nativeRead_;

            Foreign0Data(Foreign0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

