/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMI16StoreNode.class)
public final class LLVMI16StoreNodeGen
extends LLVMI16StoreNode {
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private OpManaged0Data opManaged0_cache;
    @Node.Child
    private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;

    private LLVMI16StoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state = this.state_;
        if (state != 0 && valueValue instanceof Short) {
            LLVMPointer addressValue_;
            short valueValue_ = (Short)valueValue;
            if ((state & 1) != 0 && LLVMTypes.isNativePointer(addressValue) && !this.isAutoDerefHandle((LLVMNativePointer)(addressValue_ = LLVMTypes.asNativePointer(addressValue)))) {
                this.doOp((LLVMNativePointer)addressValue_, valueValue_);
                return;
            }
            if ((state & 6) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 2) != 0) {
                    OpManaged0Data s2_ = this.opManaged0_cache;
                    while (s2_ != null) {
                        if (s2_.nativeWrite_.accepts(addressValue_.getObject())) {
                            this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue_, s2_.nativeWrite_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    this.opManaged1Boundary(state, (LLVMManagedPointer)addressValue_, valueValue_);
                    return;
                }
            }
            if ((state & 8) != 0 && LLVMTypes.isNativePointer(addressValue) && this.isAutoDerefHandle((LLVMNativePointer)(addressValue_ = LLVMTypes.asNativePointer(addressValue)))) {
                this.doOpDerefHandle((LLVMNativePointer)addressValue_, valueValue_, this.opDerefHandle_nativeWrite_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue, valueValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManaged1Boundary(int state, LLVMManagedPointer addressValue_, short valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManaged(addressValue_, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void execute(VirtualFrame frameValue) {
        LLVMPointer addressValue__;
        short valueValue_;
        int state = this.state_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        try {
            valueValue_ = this.value_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(addressValue_, ex.getResult());
            return;
        }
        if ((state & 1) != 0 && LLVMTypes.isNativePointer(addressValue_) && !this.isAutoDerefHandle((LLVMNativePointer)(addressValue__ = LLVMTypes.asNativePointer(addressValue_)))) {
            this.doOp((LLVMNativePointer)addressValue__, valueValue_);
            return;
        }
        if ((state & 6) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
            addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
            if ((state & 2) != 0) {
                OpManaged0Data s2_ = this.opManaged0_cache;
                while (s2_ != null) {
                    if (s2_.nativeWrite_.accepts(addressValue__.getObject())) {
                        this.doOpManaged((LLVMManagedPointer)addressValue__, valueValue_, s2_.nativeWrite_);
                        return;
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                this.opManaged1Boundary0(state, (LLVMManagedPointer)addressValue__, valueValue_);
                return;
            }
        }
        if ((state & 8) != 0 && LLVMTypes.isNativePointer(addressValue_) && this.isAutoDerefHandle((LLVMNativePointer)(addressValue__ = LLVMTypes.asNativePointer(addressValue_)))) {
            this.doOpDerefHandle((LLVMNativePointer)addressValue__, valueValue_, this.opDerefHandle_nativeWrite_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManaged1Boundary0(int state, LLVMManagedPointer addressValue__, short valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManaged(addressValue__, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        LLVMPointer addressValue_;
        short valueValue_;
        boolean hasLock;
        Lock lock;
        block17: {
            lock = this.getLock();
            hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            if (!(valueValue instanceof Short)) throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
            valueValue_ = (Short)valueValue;
            if (LLVMTypes.isNativePointer(addressValue) && !this.isAutoDerefHandle((LLVMNativePointer)(addressValue_ = LLVMTypes.asNativePointer(addressValue)))) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.doOp((LLVMNativePointer)addressValue_, valueValue_);
                return;
            }
            if (!LLVMTypes.isManagedPointer(addressValue)) break block17;
            addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (exclude == 0) {
                int count2_ = 0;
                OpManaged0Data s2_ = this.opManaged0_cache;
                if ((state & 2) != 0) {
                    while (s2_ != null && !s2_.nativeWrite_.accepts(addressValue_.getObject())) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && count2_ < 3) {
                    s2_ = (OpManaged0Data)super.insert((Node)new OpManaged0Data(this.opManaged0_cache));
                    s2_.nativeWrite_ = (LLVMManagedWriteLibrary)s2_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject()));
                    this.opManaged0_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue_, s2_.nativeWrite_);
                    return;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                this.exclude_ = exclude |= 1;
                this.opManaged0_cache = null;
                state &= 0xFFFFFFFD;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }
        if (!LLVMTypes.isNativePointer(addressValue) || !this.isAutoDerefHandle((LLVMNativePointer)(addressValue_ = LLVMTypes.asNativePointer(addressValue)))) throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
        this.opDerefHandle_nativeWrite_ = (LLVMManagedWriteLibrary)super.insert((Node)L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3));
        this.state_ = state |= 8;
        lock.unlock();
        hasLock = false;
        this.doOpDerefHandle((LLVMNativePointer)addressValue_, valueValue_, this.opDerefHandle_nativeWrite_);
        return;
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        OpManaged0Data s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.opManaged0_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMI16StoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMI16StoreNodeGen(address, value);
    }

    @GeneratedBy(value=LLVMI16StoreNode.class)
    private static final class OpManaged0Data
    extends Node {
        @Node.Child
        OpManaged0Data next_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        OpManaged0Data(OpManaged0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

