/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMI64StoreNode.class)
public final class LLVMI64StoreNodeGen
extends LLVMI64StoreNode {
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private LLVMManagedWriteLibrary opDerefHandleI64_nativeWrite_;
    @Node.Child
    private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;
    @Node.Child
    private LLVMToNativeNode op1_toAddress_;
    @Node.Child
    private OpManagedI640Data opManagedI640_cache;
    @Node.Child
    private OpManaged0Data opManaged0_cache;

    private LLVMI64StoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void executeWithTarget(Object addressValue, Object valueValue) {
        long valueValue_;
        LLVMPointer addressValue_;
        int state = this.state_;
        if ((state & 0x1F) != 0 && LLVMTypes.isNativePointer(addressValue)) {
            addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((state & 3) != 0 && valueValue instanceof Long) {
                valueValue_ = (Long)valueValue;
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    this.doOp((LLVMNativePointer)addressValue_, valueValue_);
                    return;
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    this.doOpDerefHandleI64((LLVMNativePointer)addressValue_, valueValue_, this.opDerefHandleI64_nativeWrite_);
                    return;
                }
            }
            if ((state & 4) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                this.doOpDerefHandle((LLVMNativePointer)addressValue_, valueValue, this.opDerefHandle_nativeWrite_);
                return;
            }
            if ((state & 8) != 0 && LLVMTypes.isNativePointer(valueValue)) {
                LLVMNativePointer valueValue_2 = LLVMTypes.asNativePointer(valueValue);
                if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                    this.doOpNative((LLVMNativePointer)addressValue_, valueValue_2);
                    return;
                }
            }
            if ((state & 0x10) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                this.doOp((LLVMNativePointer)addressValue_, valueValue, this.op1_toAddress_);
                return;
            }
        }
        if ((state & 0x1E0) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
            addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if ((state & 0x60) != 0 && valueValue instanceof Long) {
                valueValue_ = (Long)valueValue;
                if ((state & 0x20) != 0) {
                    OpManagedI640Data s6_ = this.opManagedI640_cache;
                    while (s6_ != null) {
                        if (s6_.nativeWrite_.accepts(addressValue_.getObject())) {
                            this.doOpManagedI64((LLVMManagedPointer)addressValue_, valueValue_, s6_.nativeWrite_);
                            return;
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0) {
                    this.opManagedI641Boundary(state, (LLVMManagedPointer)addressValue_, valueValue_);
                    return;
                }
            }
            if ((state & 0x180) != 0) {
                if ((state & 0x80) != 0) {
                    OpManaged0Data s8_ = this.opManaged0_cache;
                    while (s8_ != null) {
                        if (s8_.nativeWrite_.accepts(addressValue_.getObject())) {
                            this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue, s8_.nativeWrite_);
                            return;
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0) {
                    this.opManaged1Boundary(state, (LLVMManagedPointer)addressValue_, valueValue);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue, valueValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManagedI641Boundary(int state, LLVMManagedPointer addressValue_, long valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManagedI64(addressValue_, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManaged1Boundary(int state, LLVMManagedPointer addressValue_, Object valueValue) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManaged(addressValue_, valueValue, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x19C) == 0 && state != 0) {
            this.execute_long0(frameValue, state);
            return;
        }
        this.execute_generic1(frameValue, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManagedI641Boundary0(int state, LLVMManagedPointer addressValue__, long valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManagedI64(addressValue__, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private void execute_long0(VirtualFrame frameValue, int state) {
        LLVMPointer addressValue__;
        long valueValue_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        try {
            valueValue_ = this.value_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(addressValue_, ex.getResult());
            return;
        }
        if ((state & 3) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
            addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                this.doOp((LLVMNativePointer)addressValue__, valueValue_);
                return;
            }
            if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                this.doOpDerefHandleI64((LLVMNativePointer)addressValue__, valueValue_, this.opDerefHandleI64_nativeWrite_);
                return;
            }
        }
        if ((state & 0x60) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
            addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
            if ((state & 0x20) != 0) {
                OpManagedI640Data s6_ = this.opManagedI640_cache;
                while (s6_ != null) {
                    if (s6_.nativeWrite_.accepts(addressValue__.getObject())) {
                        this.doOpManagedI64((LLVMManagedPointer)addressValue__, valueValue_, s6_.nativeWrite_);
                        return;
                    }
                    s6_ = s6_.next_;
                }
            }
            if ((state & 0x40) != 0) {
                this.opManagedI641Boundary0(state, (LLVMManagedPointer)addressValue__, valueValue_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManagedI641Boundary1(int state, LLVMManagedPointer addressValue__, long valueValue__) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManagedI64(addressValue__, valueValue__, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void opManaged1Boundary2(int state, LLVMManagedPointer addressValue__, Object valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doOpManaged(addressValue__, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private void execute_generic1(VirtualFrame frameValue, int state) {
        long valueValue__;
        LLVMPointer addressValue__;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if ((state & 0x1F) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
            addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if ((state & 3) != 0 && valueValue_ instanceof Long) {
                valueValue__ = (Long)valueValue_;
                if ((state & 1) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    this.doOp((LLVMNativePointer)addressValue__, valueValue__);
                    return;
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    this.doOpDerefHandleI64((LLVMNativePointer)addressValue__, valueValue__, this.opDerefHandleI64_nativeWrite_);
                    return;
                }
            }
            if ((state & 4) != 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                this.doOpDerefHandle((LLVMNativePointer)addressValue__, valueValue_, this.opDerefHandle_nativeWrite_);
                return;
            }
            if ((state & 8) != 0 && LLVMTypes.isNativePointer(valueValue_)) {
                LLVMNativePointer valueValue__2 = LLVMTypes.asNativePointer(valueValue_);
                if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                    this.doOpNative((LLVMNativePointer)addressValue__, valueValue__2);
                    return;
                }
            }
            if ((state & 0x10) != 0 && !this.isAutoDerefHandle((LLVMNativePointer)addressValue__)) {
                this.doOp((LLVMNativePointer)addressValue__, valueValue_, this.op1_toAddress_);
                return;
            }
        }
        if ((state & 0x1E0) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
            addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
            if ((state & 0x60) != 0 && valueValue_ instanceof Long) {
                valueValue__ = (Long)valueValue_;
                if ((state & 0x20) != 0) {
                    OpManagedI640Data s6_ = this.opManagedI640_cache;
                    while (s6_ != null) {
                        if (s6_.nativeWrite_.accepts(addressValue__.getObject())) {
                            this.doOpManagedI64((LLVMManagedPointer)addressValue__, valueValue__, s6_.nativeWrite_);
                            return;
                        }
                        s6_ = s6_.next_;
                    }
                }
                if ((state & 0x40) != 0) {
                    this.opManagedI641Boundary1(state, (LLVMManagedPointer)addressValue__, valueValue__);
                    return;
                }
            }
            if ((state & 0x180) != 0) {
                if ((state & 0x80) != 0) {
                    OpManaged0Data s8_ = this.opManaged0_cache;
                    while (s8_ != null) {
                        if (s8_.nativeWrite_.accepts(addressValue__.getObject())) {
                            this.doOpManaged((LLVMManagedPointer)addressValue__, valueValue_, s8_.nativeWrite_);
                            return;
                        }
                        s8_ = s8_.next_;
                    }
                }
                if ((state & 0x100) != 0) {
                    this.opManaged1Boundary2(state, (LLVMManagedPointer)addressValue__, valueValue_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        LLVMPointer addressValue_;
        int exclude;
        int state;
        boolean hasLock;
        Lock lock;
        block37: {
            long valueValue_;
            block38: {
                OpManagedI640Data s6_;
                int count6_;
                block39: {
                    block40: {
                        block36: {
                            lock = this.getLock();
                            hasLock = true;
                            lock.lock();
                            state = this.state_;
                            exclude = this.exclude_;
                            if (LLVMTypes.isNativePointer(addressValue)) {
                                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                                if (valueValue instanceof Long) {
                                    long valueValue_2 = (Long)valueValue;
                                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                                        this.state_ = state |= 1;
                                        lock.unlock();
                                        hasLock = false;
                                        this.doOp((LLVMNativePointer)addressValue_, valueValue_2);
                                        return;
                                    }
                                    if ((exclude & 1) == 0 && this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                                        this.opDerefHandleI64_nativeWrite_ = (LLVMManagedWriteLibrary)super.insert((Node)L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3));
                                        this.state_ = state |= 2;
                                        lock.unlock();
                                        hasLock = false;
                                        this.doOpDerefHandleI64((LLVMNativePointer)addressValue_, valueValue_2, this.opDerefHandleI64_nativeWrite_);
                                        return;
                                    }
                                }
                                if (this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                                    this.opDerefHandle_nativeWrite_ = (LLVMManagedWriteLibrary)super.insert((Node)L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3));
                                    this.exclude_ = exclude |= 1;
                                    state &= 0xFFFFFFFD;
                                    this.state_ = state |= 4;
                                    lock.unlock();
                                    hasLock = false;
                                    this.doOpDerefHandle((LLVMNativePointer)addressValue_, valueValue, this.opDerefHandle_nativeWrite_);
                                    return;
                                }
                                if ((exclude & 2) == 0 && LLVMTypes.isNativePointer(valueValue)) {
                                    LLVMNativePointer valueValue_3 = LLVMTypes.asNativePointer(valueValue);
                                    if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                                        this.state_ = state |= 8;
                                        lock.unlock();
                                        hasLock = false;
                                        this.doOpNative((LLVMNativePointer)addressValue_, valueValue_3);
                                        return;
                                    }
                                }
                                if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_)) {
                                    this.op1_toAddress_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                                    this.exclude_ = exclude |= 2;
                                    state &= 0xFFFFFFF7;
                                    this.state_ = state |= 0x10;
                                    lock.unlock();
                                    hasLock = false;
                                    this.doOp((LLVMNativePointer)addressValue_, valueValue, this.op1_toAddress_);
                                    return;
                                }
                            }
                            if (!LLVMTypes.isManagedPointer(addressValue)) break block36;
                            addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                            if (!(valueValue instanceof Long)) break block37;
                            valueValue_ = (Long)valueValue;
                            if ((exclude & 4) != 0) break block38;
                            count6_ = 0;
                            s6_ = this.opManagedI640_cache;
                            if ((state & 0x20) == 0) break block39;
                            break block40;
                        }
                        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
                        finally {
                            if (hasLock) {
                                lock.unlock();
                            }
                        }
                    }
                    while (s6_ != null && !s6_.nativeWrite_.accepts(addressValue_.getObject())) {
                        s6_ = s6_.next_;
                        ++count6_;
                    }
                }
                if (s6_ == null && count6_ < 3) {
                    s6_ = (OpManagedI640Data)super.insert((Node)new OpManagedI640Data(this.opManagedI640_cache));
                    s6_.nativeWrite_ = (LLVMManagedWriteLibrary)s6_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject()));
                    this.opManagedI640_cache = s6_;
                    this.state_ = state |= 0x20;
                }
                if (s6_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.doOpManagedI64((LLVMManagedPointer)addressValue_, valueValue_, s6_.nativeWrite_);
                    return;
                }
            }
            if ((exclude & 8) == 0) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.exclude_ = exclude |= 4;
                    this.opManagedI640_cache = null;
                    state &= 0xFFFFFFDF;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    this.doOpManagedI64((LLVMManagedPointer)addressValue_, valueValue_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                    return;
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
        }
        if ((exclude & 0x10) == 0) {
            int count8_ = 0;
            OpManaged0Data s8_ = this.opManaged0_cache;
            if ((state & 0x80) != 0) {
                while (s8_ != null && !s8_.nativeWrite_.accepts(addressValue_.getObject())) {
                    s8_ = s8_.next_;
                    ++count8_;
                }
            }
            if (s8_ == null && count8_ < 3) {
                s8_ = (OpManaged0Data)super.insert((Node)new OpManaged0Data(this.opManaged0_cache));
                s8_.nativeWrite_ = (LLVMManagedWriteLibrary)s8_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject()));
                this.opManaged0_cache = s8_;
                this.exclude_ = exclude |= 0xC;
                this.opManagedI640_cache = null;
                state &= 0xFFFFFF9F;
                this.state_ = state |= 0x80;
            }
            if (s8_ != null) {
                lock.unlock();
                hasLock = false;
                this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue, s8_.nativeWrite_);
                return;
            }
        }
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.exclude_ = exclude |= 0x1C;
            this.opManagedI640_cache = null;
            this.opManaged0_cache = null;
            state &= 0xFFFFFF1F;
            this.state_ = state |= 0x100;
            lock.unlock();
            hasLock = false;
            this.doOpManaged((LLVMManagedPointer)addressValue_, valueValue, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            OpManagedI640Data s6_ = this.opManagedI640_cache;
            OpManaged0Data s8_ = this.opManaged0_cache;
            if (!(s6_ != null && s6_.next_ != null || s8_ != null && s8_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMI64StoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMI64StoreNodeGen(address, value);
    }

    @GeneratedBy(value=LLVMI64StoreNode.class)
    private static final class OpManaged0Data
    extends Node {
        @Node.Child
        OpManaged0Data next_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        OpManaged0Data(OpManaged0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=LLVMI64StoreNode.class)
    private static final class OpManagedI640Data
    extends Node {
        @Node.Child
        OpManagedI640Data next_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        OpManagedI640Data(OpManagedI640Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

