/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAbstractCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMPointerCompareNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMPointerCompareNode
extends LLVMAbstractCompareNode {
    private final NativePointerCompare op;

    public LLVMPointerCompareNode(NativePointerCompare op) {
        this.op = op;
    }

    @Specialization(guards={"libA.isPointer(a)", "libB.isPointer(b)"}, limit="3", rewriteOn={UnsupportedMessageException.class})
    protected boolean doPointerPointer(Object a, Object b, @CachedLibrary(value="a") LLVMNativeLibrary libA, @CachedLibrary(value="b") LLVMNativeLibrary libB) throws UnsupportedMessageException {
        return this.op.compare(libA.asPointer(a), libB.asPointer(b));
    }

    @Specialization(guards={"libA.isPointer(a)", "libB.isPointer(b)"}, limit="3")
    protected boolean doPointerPointerException(Object a, Object b, @CachedLibrary(value="a") LLVMNativeLibrary libA, @CachedLibrary(value="b") LLVMNativeLibrary libB, @Cached LLVMManagedCompareNode managedCompare) {
        try {
            return this.doPointerPointer(a, b, libA, libB);
        }
        catch (UnsupportedMessageException ex) {
            return this.doOther(a, b, libA, libB, managedCompare);
        }
    }

    @Specialization(guards={"!libA.isPointer(a) || !libB.isPointer(b)"}, limit="3")
    protected boolean doOther(Object a, Object b, @CachedLibrary(value="a") LLVMNativeLibrary libA, @CachedLibrary(value="b") LLVMNativeLibrary libB, @Cached LLVMManagedCompareNode managedCompare) {
        return managedCompare.execute(a, libA, b, libB, this.op);
    }

    public static LLVMAbstractCompareNode create(Kind kind, LLVMExpressionNode l, LLVMExpressionNode r) {
        switch (kind) {
            case SLT: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return a < b;
                    }
                }, l, r);
            }
            case SLE: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return a <= b;
                    }
                }, l, r);
            }
            case ULE: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return Long.compareUnsigned(a, b) <= 0;
                    }
                }, l, r);
            }
            case ULT: {
                return LLVMPointerCompareNodeGen.create(new NativePointerCompare(){

                    @Override
                    public boolean compare(long a, long b) {
                        return Long.compareUnsigned(a, b) < 0;
                    }
                }, l, r);
            }
            case EQ: {
                return LLVMAddressEqualsNodeGen.create(l, r);
            }
            case NEQ: {
                return LLVMNegateNode.create(LLVMAddressEqualsNodeGen.create(l, r));
            }
        }
        throw new AssertionError();
    }

    public static final class LLVMNegateNode
    extends LLVMAbstractCompareNode {
        @Node.Child
        private LLVMAbstractCompareNode booleanExpression;

        private LLVMNegateNode(LLVMAbstractCompareNode booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public static LLVMAbstractCompareNode create(LLVMAbstractCompareNode booleanExpression) {
            return new LLVMNegateNode(booleanExpression);
        }

        @Override
        public boolean executeWithTarget(Object a, Object b) {
            return !this.booleanExpression.executeWithTarget(a, b);
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.executeGenericBoolean(frame);
        }

        @Override
        public boolean executeGenericBoolean(VirtualFrame frame) {
            return !this.booleanExpression.executeGenericBoolean(frame);
        }
    }

    static abstract class LLVMManagedCompareNode
    extends LLVMNode {
        private static final long TYPICAL_POINTER = 0x7F0000000000L;

        LLVMManagedCompareNode() {
        }

        abstract boolean execute(Object var1, LLVMNativeLibrary var2, Object var3, LLVMNativeLibrary var4, NativePointerCompare var5);

        @Specialization(limit="3", guards={"pointToSameObject.isSame(a.getObject(), b.getObject())"})
        protected boolean doForeign(LLVMManagedPointer a, LLVMNativeLibrary libA, LLVMManagedPointer b, LLVMNativeLibrary libB, NativePointerCompare op, @CachedLibrary(value="a.getObject()") ReferenceLibrary pointToSameObject) {
            return op.compare(0x7F0000000000L + a.getOffset(), 0x7F0000000000L + b.getOffset());
        }

        @Specialization(limit="3", guards={"!pointToSameObject.isSame(a.getObject(), b.getObject())"})
        protected boolean doForeign(LLVMManagedPointer a, LLVMNativeLibrary libA, LLVMManagedPointer b, LLVMNativeLibrary libB, NativePointerCompare op, @CachedLibrary(value="a.getObject()") ReferenceLibrary pointToSameObject, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convertA, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convertB) {
            return op.compare(convertA.executeWithTarget(a), convertB.executeWithTarget(b));
        }

        @Specialization(guards={"libA.isPointer(a)"}, rewriteOn={UnsupportedMessageException.class})
        protected boolean doNativeManaged(Object a, LLVMNativeLibrary libA, Object b, LLVMNativeLibrary libB, NativePointerCompare op, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convert) throws UnsupportedMessageException {
            return op.compare(libA.asPointer(a), convert.executeWithTarget(b));
        }

        @Specialization(guards={"libB.isPointer(b)"}, rewriteOn={UnsupportedMessageException.class})
        protected boolean doManagedNative(Object a, LLVMNativeLibrary libA, Object b, LLVMNativeLibrary libB, NativePointerCompare op, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convert) throws UnsupportedMessageException {
            return op.compare(convert.executeWithTarget(a), libB.asPointer(b));
        }

        @Specialization(guards={"libA.isPointer(a) || libB.isPointer(b)"})
        protected boolean doManagedNativeException(Object a, LLVMNativeLibrary libA, Object b, LLVMNativeLibrary libB, NativePointerCompare op, @Cached(value="createIgnoreOffset()") ToComparableValue.ManagedToComparableValue convert) {
            try {
                return op.compare(libA.asPointer(a), convert.executeWithTarget(b));
            }
            catch (UnsupportedMessageException e) {
                try {
                    return op.compare(convert.executeWithTarget(a), libB.asPointer(b));
                }
                catch (UnsupportedMessageException ex) {
                    return op.compare(convert.executeWithTarget(a), convert.executeWithTarget(b));
                }
            }
        }
    }

    protected static abstract class NativePointerCompare {
        protected NativePointerCompare() {
        }

        abstract boolean compare(long var1, long var3);
    }

    public static enum Kind {
        ULT,
        ULE,
        SLT,
        SLE,
        EQ,
        NEQ;

    }
}

