/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMValueProfilingNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMValueProfilingNode.class)
public final class LLVMValueProfilingNodeFactory {

    @GeneratedBy(value=LLVMValueProfilingNode.LLVMDoubleProfiledValueNode.class)
    static final class LLVMDoubleProfiledValueNodeGen
    extends LLVMValueProfilingNode.LLVMDoubleProfiledValueNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMDoubleProfiledValueNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            int state = this.state_;
            if (state != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.doFloat(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doFloat(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            double child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doFloat(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private double executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                this.state_ = state |= 1;
                return this.doFloat(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMValueProfilingNode.LLVMDoubleProfiledValueNode create(LLVMExpressionNode child0) {
            return new LLVMDoubleProfiledValueNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMValueProfilingNode.LLVMFloatProfiledValueNode.class)
    static final class LLVMFloatProfiledValueNodeGen
    extends LLVMValueProfilingNode.LLVMFloatProfiledValueNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMFloatProfiledValueNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            int state = this.state_;
            if (state != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return Float.valueOf(this.doFloat(child0Value_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(child0Value));
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            if (state != 0) {
                return Float.valueOf(this.doFloat(child0Value_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(Float.valueOf(child0Value_)));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            float child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doFloat(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(child0Value_));
        }

        private float executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                this.state_ = state |= 1;
                return this.doFloat(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMValueProfilingNode.LLVMFloatProfiledValueNode create(LLVMExpressionNode child0) {
            return new LLVMFloatProfiledValueNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMValueProfilingNode.LLVMI64ProfiledValueNode.class)
    static final class LLVMI64ProfiledValueNodeGen
    extends LLVMValueProfilingNode.LLVMI64ProfiledValueNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI64ProfiledValueNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            int state = this.state_;
            if ((state & 1) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.doI64(child0Value_);
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.doPointer(child0Value_);
            }
            if ((state & 4) != 0 && LLVMI64ProfiledValueNodeGen.fallbackGuard_(state, child0Value)) {
                return this.noCache(child0Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state);
            }
            return this.executeGeneric_generic1(frameValue, state);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
            long child0Value_;
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(child0Value_);
        }

        private Object executeGeneric_generic1(VirtualFrame frameValue, int state) {
            Object child0Value_ = this.child0_.executeGeneric(frameValue);
            if ((state & 1) != 0 && child0Value_ instanceof Long) {
                long child0Value__ = (Long)child0Value_;
                return this.doI64(child0Value__);
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(child0Value_)) {
                LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
                return this.doPointer(child0Value__);
            }
            if ((state & 4) != 0 && LLVMI64ProfiledValueNodeGen.fallbackGuard_(state, child0Value_)) {
                return this.noCache(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            long child0Value_;
            int state = this.state_;
            if ((state & 4) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            try {
                child0Value_ = this.child0_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if ((state & 1) != 0) {
                return this.doI64(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(child0Value_));
        }

        private Object executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                this.state_ = state |= 1;
                return this.doI64(child0Value_);
            }
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                this.state_ = state |= 2;
                return this.doPointer(child0Value_);
            }
            this.state_ = state |= 4;
            return this.noCache(child0Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, Object child0Value) {
            if ((state & 1) == 0 && child0Value instanceof Long) {
                return false;
            }
            return (state & 2) != 0 || !LLVMTypes.isPointer(child0Value);
        }

        public static LLVMValueProfilingNode.LLVMI64ProfiledValueNode create(LLVMExpressionNode child0) {
            return new LLVMI64ProfiledValueNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMValueProfilingNode.LLVMI32ProfiledValueNode.class)
    static final class LLVMI32ProfiledValueNodeGen
    extends LLVMValueProfilingNode.LLVMI32ProfiledValueNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32ProfiledValueNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            int state = this.state_;
            if (state != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.doI32(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private int executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                this.state_ = state |= 1;
                return this.doI32(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMValueProfilingNode.LLVMI32ProfiledValueNode create(LLVMExpressionNode child0) {
            return new LLVMI32ProfiledValueNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMValueProfilingNode.LLVMI16ProfiledValueNode.class)
    static final class LLVMI16ProfiledValueNodeGen
    extends LLVMValueProfilingNode.LLVMI16ProfiledValueNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16ProfiledValueNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            int state = this.state_;
            if (state != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.doI1(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI1(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI1(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private short executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                this.state_ = state |= 1;
                return this.doI1(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMValueProfilingNode.LLVMI16ProfiledValueNode create(LLVMExpressionNode child0) {
            return new LLVMI16ProfiledValueNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMValueProfilingNode.LLVMI8ProfiledValueNode.class)
    static final class LLVMI8ProfiledValueNodeGen
    extends LLVMValueProfilingNode.LLVMI8ProfiledValueNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8ProfiledValueNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            int state = this.state_;
            if (state != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.doI8(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI8(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI8(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private byte executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                this.state_ = state |= 1;
                return this.doI8(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMValueProfilingNode.LLVMI8ProfiledValueNode create(LLVMExpressionNode child0) {
            return new LLVMI8ProfiledValueNodeGen(child0);
        }
    }

    @GeneratedBy(value=LLVMValueProfilingNode.LLVMI1ProfiledValueNode.class)
    static final class LLVMI1ProfiledValueNodeGen
    extends LLVMValueProfilingNode.LLVMI1ProfiledValueNode {
        @Node.Child
        private LLVMExpressionNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI1ProfiledValueNodeGen(LLVMExpressionNode child0) {
            this.child0_ = child0;
        }

        @Override
        public Object executeWithTarget(Object child0Value) {
            int state = this.state_;
            if (state != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.doI1(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            boolean child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI1(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            boolean child0Value_;
            int state = this.state_;
            try {
                child0Value_ = this.child0_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI1(child0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        private boolean executeAndSpecialize(Object child0Value) {
            int state = this.state_;
            if (child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                this.state_ = state |= 1;
                return this.doI1(child0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMValueProfilingNode.LLVMI1ProfiledValueNode create(LLVMExpressionNode child0) {
            return new LLVMI1ProfiledValueNodeGen(child0);
        }
    }
}

