/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;

@GeneratedBy(value=LLVMPointerImpl.class)
final class LLVMPointerImplGen {
    private LLVMPointerImplGen() {
    }

    static {
        LibraryExport.register(LLVMPointerImpl.class, (LibraryExport[])new LibraryExport[]{new DynamicDispatchLibraryExports()});
    }

    @GeneratedBy(value=LLVMPointerImpl.class)
    private static final class DynamicDispatchLibraryExports
    extends LibraryExport<DynamicDispatchLibrary> {
        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, LLVMPointerImpl.class, false);
        }

        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Uncached(receiver);
        }

        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMPointerImpl.class)
        private static final class Uncached
        extends DynamicDispatchLibrary {
            private final Class<? extends LLVMPointerImpl> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMPointerImpl)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_;
            }

            @CompilerDirectives.TruffleBoundary
            public Object cast(Object receiver) {
                return (LLVMPointerImpl)receiver;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Class<?> dispatch(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMPointerImpl)receiver).dispatch();
            }
        }

        @GeneratedBy(value=LLVMPointerImpl.class)
        private static final class Cached
        extends DynamicDispatchLibrary {
            private final Class<? extends LLVMPointerImpl> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((LLVMPointerImpl)receiver).getClass();
            }

            public Object cast(Object receiver) {
                return CompilerDirectives.castExact((Object)receiver, this.receiverClass_);
            }

            public boolean accepts(Object receiver) {
                return receiver.getClass() == this.receiverClass_;
            }

            public Class<?> dispatch(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMPointerImpl)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).dispatch();
            }
        }
    }
}

