/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import com.oracle.truffle.llvm.runtime.pointer.NativePointerLibraries;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativePointerLibraries.class)
final class NativePointerLibrariesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private NativePointerLibrariesGen() {
    }

    static {
        LibraryExport.register(NativePointerLibraries.class, (LibraryExport[])new LibraryExport[]{new LLVMNativeLibraryExports(), new InteropLibraryExports(), new ReferenceLibraryExports()});
    }

    @GeneratedBy(value=NativePointerLibraries.class)
    private static final class ReferenceLibraryExports
    extends LibraryExport<ReferenceLibrary> {
        private ReferenceLibraryExports() {
            super(ReferenceLibrary.class, LLVMPointerImpl.class, false);
        }

        protected ReferenceLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Uncached(receiver);
        }

        protected ReferenceLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Uncached
        extends ReferenceLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == NativePointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.LLVMPointerEqualsNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
            }
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Cached
        extends ReferenceLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @Node.Child
            private LLVMAddressEqualsNode.LLVMPointerEqualsNode native_equals_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == NativePointerLibraries.class;
            }

            public boolean isSame(Object arg0Value_, Object arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        return CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, this.native_equals_);
                    }
                    if ((state & 2) != 0 && Cached.fallbackGuard_(state, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        this.native_equals_ = (LLVMAddressEqualsNode.LLVMPointerEqualsNode)super.insert((Node)LLVMAddressEqualsNodeGen.LLVMPointerEqualsNodeGen.create());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = CommonPointerLibraries.IsSame.doNative(arg0Value, arg1Value_, this.native_equals_);
                        return bl;
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.IsSame.doOther(arg0Value, arg1Value);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            private static boolean fallbackGuard_(int state, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state & 1) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }
        }
    }

    @GeneratedBy(value=NativePointerLibraries.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMPointerImpl.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Uncached(receiver);
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_ = this.lookupContextReference(LLVMLanguage.class);

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == NativePointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getMembers(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readMember(arg0Value, arg1Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getArraySize(arg0Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return NativePointerLibraries.IsExecutable.doNative(arg0Value, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return NativePointerLibraries.Execute.doNative(arg0Value, arg1Value, (LLVMContext)this.lLVMLanguageContextReference_.get(), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isNull((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isPointer((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.asPointer((LLVMPointerImpl)receiver);
            }
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isObject;
            @Node.Child
            private LLVMForeignGetMemberPointerNode getMember;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isArray;
            @Node.Child
            private LLVMForeignGetIndexPointerNode getIndex;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
            @Node.Child
            private LLVMForeignReadNode readMemberNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeMemberNode__write_;
            @Node.Child
            private LLVMForeignReadNode readArrayElementNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeArrayElementNode__write_;
            @Node.Child
            private ExecuteNativeCachedData execute_nativeCached_cache;
            @Node.Child
            private InteropLibrary execute_native_interop_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == NativePointerLibraries.class;
            }

            public boolean hasMembers(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 1) != 0) {
                    return CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getMembersNode_AndSpecialize(LLVMPointerImpl arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 2) != 0) {
                    return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 4) != 0) {
                    return CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.readMemberNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 8) != 0) {
                    return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver), member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.writeMemberNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    return CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    long l = CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x80) != 0) {
                    return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.readArrayElementNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x100) != 0) {
                    return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.createBinaryProfile();
                    }
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver), index);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x200) != 0) {
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.writeArrayElementNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x400) != 0) {
                    return NativePointerLibraries.IsExecutable.doNative(arg0Value, (LLVMContext)this.lLVMLanguageContextReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isExecutableAndSpecialize(LLVMPointerImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__ == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = NativePointerLibraries.IsExecutable.doNative(arg0Value, (LLVMContext)lLVMLanguageContextReference__.get());
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 0x1800) != 0) {
                    if ((state & 0x800) != 0) {
                        ExecuteNativeCachedData s1_ = this.execute_nativeCached_cache;
                        while (s1_ != null) {
                            assert (s1_.interop_.accepts((Object)s1_.cachedDescriptor_));
                            if (arg0Value.asNative() == s1_.cachedAddress_) {
                                assert (s1_.cachedDescriptor_ != null);
                                return NativePointerLibraries.Execute.doNativeCached(arg0Value, arg1Value, s1_.cachedAddress_, this.lLVMLanguageContextReference_, s1_.cachedDescriptor_, s1_.interop_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0x1000) != 0) {
                        return NativePointerLibraries.Execute.doNative(arg0Value, arg1Value, (LLVMContext)this.lLVMLanguageContextReference_.get(), this.execute_native_interop_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(LLVMPointerImpl arg0Value, Object[] arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__;
                    if (exclude == 0) {
                        int count1_ = 0;
                        ExecuteNativeCachedData s1_ = this.execute_nativeCached_cache;
                        if ((state & 0x800) != 0) {
                            while (s1_ != null) {
                                assert (s1_.interop_.accepts((Object)s1_.cachedDescriptor_));
                                if (arg0Value.asNative() == s1_.cachedAddress_) {
                                    assert (s1_.cachedDescriptor_ != null);
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null) {
                            long cachedAddress__ = arg0Value.asNative();
                            if (arg0Value.asNative() == cachedAddress__) {
                                TruffleLanguage.ContextReference ctxRef__;
                                LLVMFunctionDescriptor cachedDescriptor__;
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__2 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                if ((cachedDescriptor__ = NativePointerLibraries.Execute.getDescriptor(ctxRef__ = lLVMLanguageContextReference__2, arg0Value)) != null && count1_ < 5) {
                                    s1_ = (ExecuteNativeCachedData)super.insert((Node)new ExecuteNativeCachedData(this.execute_nativeCached_cache));
                                    s1_.cachedAddress_ = cachedAddress__;
                                    s1_.cachedDescriptor_ = cachedDescriptor__;
                                    s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create((Object)cachedDescriptor__));
                                    this.execute_nativeCached_cache = s1_;
                                    this.state_ = state |= 0x800;
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = NativePointerLibraries.Execute.doNativeCached(arg0Value, arg1Value, s1_.cachedAddress_, this.lLVMLanguageContextReference_, s1_.cachedDescriptor_, s1_.interop_);
                            return object;
                        }
                    }
                    if ((lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_) == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                    }
                    this.execute_native_interop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(5));
                    this.exclude_ = exclude |= 1;
                    this.execute_nativeCached_cache = null;
                    state &= 0xFFFFF7FF;
                    this.state_ = state |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    Object object = NativePointerLibraries.Execute.doNative(arg0Value, arg1Value, (LLVMContext)lLVMLanguageContextReference__.get(), this.execute_native_interop_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isNull(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isNull((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public boolean isPointer(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isPointer((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.asPointer((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            @GeneratedBy(value=NativePointerLibraries.class)
            private static final class ExecuteNativeCachedData
            extends Node {
                @Node.Child
                ExecuteNativeCachedData next_;
                @CompilerDirectives.CompilationFinal
                long cachedAddress_;
                @CompilerDirectives.CompilationFinal
                LLVMFunctionDescriptor cachedDescriptor_;
                @Node.Child
                InteropLibrary interop_;

                ExecuteNativeCachedData(ExecuteNativeCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }

    @GeneratedBy(value=NativePointerLibraries.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Uncached(receiver);
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Uncached
        extends LLVMNativeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == NativePointerLibraries.class;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isPointer((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.asPointer((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.toNativePointer((LLVMPointerImpl)receiver);
            }
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == NativePointerLibraries.class;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isPointer((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.asPointer((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public LLVMNativePointer toNativePointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.toNativePointer((LLVMPointerImpl)this.dynamicDispatch_.cast(receiver));
            }
        }
    }
}

