/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public abstract class Type {
    public static final Type[] EMPTY_ARRAY = new Type[0];

    public abstract int getBitSize();

    public abstract void accept(TypeVisitor var1);

    public abstract int getAlignment(DataLayout var1);

    public abstract int getSize(DataLayout var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static Type getIntegerType(int size) {
        switch (size) {
            case 1: {
                return PrimitiveType.I1;
            }
            case 8: {
                return PrimitiveType.I8;
            }
            case 16: {
                return PrimitiveType.I16;
            }
            case 32: {
                return PrimitiveType.I32;
            }
            case 64: {
                return PrimitiveType.I64;
            }
        }
        return new VariableBitWidthType(size);
    }

    public static Type createConstantForType(Type type, Object value) {
        if (type instanceof PrimitiveType) {
            return new PrimitiveType(((PrimitiveType)type).getPrimitiveKind(), value);
        }
        return new VariableBitWidthType(((VariableBitWidthType)type).getBitSize(), value);
    }

    public static boolean isIntegerType(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitive.getPrimitiveKind();
            return kind == PrimitiveType.PrimitiveKind.I1 || kind == PrimitiveType.PrimitiveKind.I8 || kind == PrimitiveType.PrimitiveKind.I16 || kind == PrimitiveType.PrimitiveKind.I32 || kind == PrimitiveType.PrimitiveKind.I64;
        }
        return type instanceof VariableBitWidthType;
    }

    public static boolean isFloatingpointType(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitive.getPrimitiveKind();
            return kind == PrimitiveType.PrimitiveKind.F128 || kind == PrimitiveType.PrimitiveKind.FLOAT || kind == PrimitiveType.PrimitiveKind.HALF || kind == PrimitiveType.PrimitiveKind.PPC_FP128 || kind == PrimitiveType.PrimitiveKind.X86_FP80 || kind == PrimitiveType.PrimitiveKind.DOUBLE;
        }
        return false;
    }

    public static FrameSlotKind getFrameSlotKind(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitive.getPrimitiveKind();
            switch (kind) {
                case FLOAT: {
                    return FrameSlotKind.Float;
                }
                case DOUBLE: {
                    return FrameSlotKind.Double;
                }
                case I1: {
                    return FrameSlotKind.Boolean;
                }
                case I16: 
                case I32: {
                    return FrameSlotKind.Int;
                }
                case I64: {
                    return FrameSlotKind.Long;
                }
                case I8: {
                    return FrameSlotKind.Byte;
                }
            }
            return FrameSlotKind.Object;
        }
        if (type instanceof VariableBitWidthType) {
            switch (type.getBitSize()) {
                case 1: {
                    return FrameSlotKind.Boolean;
                }
                case 8: {
                    return FrameSlotKind.Byte;
                }
                case 16: 
                case 32: {
                    return FrameSlotKind.Int;
                }
                case 64: {
                    return FrameSlotKind.Long;
                }
            }
            return FrameSlotKind.Object;
        }
        return FrameSlotKind.Object;
    }

    public static int getPadding(long offset, int alignment) {
        assert ((alignment == 0 ? 0L : ((long)alignment - offset % (long)alignment) % (long)alignment) == (long)((int)(alignment == 0 ? 0L : ((long)alignment - offset % (long)alignment) % (long)alignment)));
        return (int)(alignment == 0 ? 0L : ((long)alignment - offset % (long)alignment) % (long)alignment);
    }

    public static int getPadding(long offset, Type type, DataLayout targetDataLayout) {
        int alignment = type.getAlignment(targetDataLayout);
        return Type.getPadding(offset, alignment);
    }
}

