/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.vector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

@CompilerDirectives.ValueType
public final class LLVMFloatVector
extends LLVMVector {
    private final float[] vector;

    public static LLVMFloatVector create(float[] vector) {
        return new LLVMFloatVector(vector);
    }

    private LLVMFloatVector(float[] vector) {
        this.vector = vector;
    }

    public float getValue(int index) {
        return this.vector[index];
    }

    @Override
    public int getLength() {
        return this.vector.length;
    }

    @Override
    public Type getElementType() {
        return PrimitiveType.FLOAT;
    }

    @Override
    public Object getElement(int index) {
        return index >= 0 && index < this.vector.length ? Float.valueOf(this.vector[index]) : null;
    }
}

