/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.regex.tregex.automaton.StateSetBackingSet;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public class StateSetBackingSortedArray
implements StateSetBackingSet {
    private short[] array;
    private short size;

    public StateSetBackingSortedArray() {
        this.array = new short[8];
    }

    private StateSetBackingSortedArray(StateSetBackingSortedArray copy) {
        this.array = Arrays.copyOf(copy.array, copy.array.length);
        this.size = copy.size;
    }

    @Override
    public StateSetBackingSet copy() {
        return new StateSetBackingSortedArray(this);
    }

    private int find(short id) {
        return Arrays.binarySearch(this.array, 0, (int)this.size, id);
    }

    private void checkGrow() {
        if (this.array.length == this.size) {
            this.array = Arrays.copyOf(this.array, this.array.length * 2);
        }
    }

    @Override
    public boolean contains(short id) {
        return this.find(id) >= 0;
    }

    @Override
    public boolean add(short id) {
        this.checkGrow();
        int searchResult = this.find(id);
        if (searchResult >= 0) {
            return false;
        }
        int insertionPoint = (searchResult + 1) * -1;
        System.arraycopy(this.array, insertionPoint, this.array, insertionPoint + 1, this.size - insertionPoint);
        this.size = (short)(this.size + 1);
        this.array[insertionPoint] = id;
        return true;
    }

    @Override
    public void addBatch(short id) {
        this.checkGrow();
        short s = this.size;
        this.size = (short)(s + 1);
        this.array[s] = id;
    }

    @Override
    public void addBatchFinish() {
        Arrays.sort(this.array, 0, (int)this.size);
    }

    @Override
    public void replace(short oldId, short newId) {
        int searchResult = this.find(newId);
        assert (searchResult < 0);
        int insertionPoint = (searchResult + 1) * -1;
        int deletionPoint = this.find(oldId);
        assert (deletionPoint >= 0);
        if (insertionPoint < deletionPoint) {
            System.arraycopy(this.array, insertionPoint, this.array, insertionPoint + 1, deletionPoint - insertionPoint);
        } else if (insertionPoint > deletionPoint) {
            System.arraycopy(this.array, deletionPoint + 1, this.array, deletionPoint, --insertionPoint - deletionPoint);
        }
        this.array[insertionPoint] = newId;
    }

    @Override
    public boolean remove(short id) {
        int searchResult = this.find(id);
        if (searchResult < 0) {
            return false;
        }
        this.removeElement(searchResult);
        return true;
    }

    private void removeElement(int i) {
        assert (i >= 0);
        System.arraycopy(this.array, i + 1, this.array, i, this.size - (i + 1));
        this.size = (short)(this.size - 1);
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isDisjoint(StateSetBackingSet other) {
        PrimitiveIterator.OfInt ofInt = this.iterator();
        while (ofInt.hasNext()) {
            int i = (Integer)ofInt.next();
            if (!other.contains((short)i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(StateSetBackingSet other) {
        PrimitiveIterator.OfInt ofInt = other.iterator();
        while (ofInt.hasNext()) {
            int i = (Integer)ofInt.next();
            if (this.contains((short)i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new PrimitiveIterator.OfInt(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < StateSetBackingSortedArray.this.size;
            }

            @Override
            public int nextInt() {
                return StateSetBackingSortedArray.this.array[this.i++];
            }

            @Override
            public void remove() {
                StateSetBackingSortedArray.this.removeElement(--this.i);
            }
        };
    }

    public int hashCode() {
        if (this.array == null) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.array[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StateSetBackingSortedArray)) {
            return false;
        }
        StateSetBackingSortedArray o = (StateSetBackingSortedArray)obj;
        if (this.size != o.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == o.array[i]) continue;
            return false;
        }
        return true;
    }
}

