/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.buffer.ByteArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import com.oracle.truffle.regex.tregex.dfa.DFAStateNodeBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.NFAStateSet;
import com.oracle.truffle.regex.tregex.dfa.NFATransitionSet;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public class DFACaptureGroupTransitionBuilder
extends DFAStateTransitionBuilder {
    private final DFAGenerator dfaGen;
    private NFAStateSet requiredStates = null;
    private DFACaptureGroupLazyTransition lazyTransition = null;

    DFACaptureGroupTransitionBuilder(CharSet matcherBuilder, NFATransitionSet transitions, DFAGenerator dfaGen) {
        super(matcherBuilder, transitions);
        this.dfaGen = dfaGen;
    }

    @Override
    public DFAStateTransitionBuilder createNodeSplitCopy() {
        return new DFACaptureGroupTransitionBuilder(this.getMatcherBuilder(), (NFATransitionSet)this.getTransitionSet(), this.dfaGen);
    }

    @Override
    public DFACaptureGroupTransitionBuilder createMerged(TransitionBuilder<NFATransitionSet> other, CharSet mergedMatcher) {
        return new DFACaptureGroupTransitionBuilder(mergedMatcher, ((NFATransitionSet)this.getTransitionSet()).createMerged(other.getTransitionSet()), this.dfaGen);
    }

    public void setLazyTransition(DFACaptureGroupLazyTransition lazyTransition) {
        this.lazyTransition = lazyTransition;
    }

    private boolean skipReorder() {
        return !this.dfaGen.getProps().isSearching() && this.getSource().isInitialState();
    }

    private NFAStateSet getRequiredStates() {
        if (this.requiredStates == null) {
            this.requiredStates = new NFAStateSet(this.dfaGen.getNfa());
            for (NFAStateTransition nfaTransition : (NFATransitionSet)this.getTransitionSet()) {
                this.requiredStates.add(nfaTransition.getSource());
            }
        }
        return this.requiredStates;
    }

    private DFACaptureGroupPartialTransition createPartialTransition(NFAStateSet targetStates, CompilationBuffer compilationBuffer) {
        int numberOfNFAStates = Math.max(this.getRequiredStates().size(), targetStates.size());
        PartialTransitionDebugInfo partialTransitionDebugInfo = null;
        if (this.dfaGen.getEngineOptions().isDumpAutomata()) {
            partialTransitionDebugInfo = new PartialTransitionDebugInfo(numberOfNFAStates);
        }
        this.dfaGen.updateMaxNumberOfNFAStatesInOneTransition(numberOfNFAStates);
        int[] newOrder = new int[numberOfNFAStates];
        Arrays.fill(newOrder, -1);
        boolean[] used = new boolean[newOrder.length];
        int[] copySource = new int[this.getRequiredStates().size()];
        ObjectArrayBuffer indexUpdates = compilationBuffer.getObjectBuffer1();
        ObjectArrayBuffer indexClears = compilationBuffer.getObjectBuffer2();
        ByteArrayBuffer arrayCopies = compilationBuffer.getByteArrayBuffer();
        for (NFAStateTransition nfaTransition : (NFATransitionSet)this.getTransitionSet()) {
            if (!targetStates.contains(nfaTransition.getTarget())) continue;
            int sourceIndex = this.getRequiredStates().getStateIndex(nfaTransition.getSource());
            int targetIndex = targetStates.getStateIndex(nfaTransition.getTarget());
            if (this.dfaGen.getEngineOptions().isDumpAutomata()) {
                partialTransitionDebugInfo.mapResultToNFATransition(targetIndex, nfaTransition);
            }
            assert (!nfaTransition.getTarget().isForwardFinalState() || targetIndex == 0);
            if (!used[sourceIndex]) {
                used[sourceIndex] = true;
                newOrder[targetIndex] = sourceIndex;
                copySource[sourceIndex] = targetIndex;
            } else {
                arrayCopies.add((byte)copySource[sourceIndex]);
                arrayCopies.add((byte)targetIndex);
            }
            if (nfaTransition.getGroupBoundaries().hasIndexUpdates()) {
                indexUpdates.add(nfaTransition.getGroupBoundaries().updatesToPartialTransitionArray(targetIndex));
            }
            if (!nfaTransition.getGroupBoundaries().hasIndexClears()) continue;
            indexClears.add(nfaTransition.getGroupBoundaries().clearsToPartialTransitionArray(targetIndex));
        }
        int order = 0;
        for (int i = 0; i < newOrder.length; ++i) {
            if (newOrder[i] != -1) continue;
            while (used[order]) {
                ++order;
            }
            newOrder[i] = order++;
        }
        byte preReorderFinalStateResultIndex = (byte)newOrder[0];
        byte[] byteArrayCopies = arrayCopies.length() == 0 ? DFACaptureGroupPartialTransition.EMPTY_ARRAY_COPIES : arrayCopies.toArray();
        byte[] reorderSwaps = this.skipReorder() ? DFACaptureGroupPartialTransition.EMPTY_REORDER_SWAPS : DFACaptureGroupTransitionBuilder.newOrderToSequenceOfSwaps(newOrder, compilationBuffer);
        DFACaptureGroupPartialTransition dfaCaptureGroupPartialTransitionNode = DFACaptureGroupPartialTransition.create(this.dfaGen, reorderSwaps, byteArrayCopies, (byte[][])indexUpdates.toArray((T[])DFACaptureGroupPartialTransition.EMPTY_INDEX_UPDATES), (byte[][])indexClears.toArray((T[])DFACaptureGroupPartialTransition.EMPTY_INDEX_CLEARS), preReorderFinalStateResultIndex);
        if (this.dfaGen.getEngineOptions().isDumpAutomata()) {
            partialTransitionDebugInfo.node = dfaCaptureGroupPartialTransitionNode;
            this.dfaGen.registerCGPartialTransitionDebugInfo(partialTransitionDebugInfo);
        }
        return dfaCaptureGroupPartialTransitionNode;
    }

    private static byte[] newOrderToSequenceOfSwaps(int[] newOrder, CompilationBuffer compilationBuffer) {
        ByteArrayBuffer swaps = compilationBuffer.getByteArrayBuffer();
        for (int i = 0; i < newOrder.length; ++i) {
            int swapSource;
            int swapTarget = swapSource = newOrder[i];
            if (swapSource == i) continue;
            do {
                swapSource = swapTarget;
                swapTarget = newOrder[swapTarget];
                swaps.add((byte)swapSource);
                swaps.add((byte)swapTarget);
                newOrder[swapSource] = swapSource;
            } while (swapTarget != i);
        }
        assert (swaps.length() / 2 < newOrder.length);
        return swaps.length() == 0 ? DFACaptureGroupPartialTransition.EMPTY_REORDER_SWAPS : swaps.toArray();
    }

    public DFACaptureGroupLazyTransition toLazyTransition(CompilationBuffer compilationBuffer) {
        if (this.lazyTransition == null) {
            DFAStateNodeBuilder successor = this.getTarget();
            DFACaptureGroupPartialTransition[] partialTransitions = new DFACaptureGroupPartialTransition[successor.getTransitions().length];
            for (int i = 0; i < successor.getTransitions().length; ++i) {
                DFACaptureGroupTransitionBuilder successorTransition = (DFACaptureGroupTransitionBuilder)successor.getTransitions()[i];
                partialTransitions[i] = this.createPartialTransition(successorTransition.getRequiredStates(), compilationBuffer);
            }
            DFACaptureGroupPartialTransition transitionToFinalState = null;
            DFACaptureGroupPartialTransition transitionToAnchoredFinalState = null;
            if (successor.isFinalState()) {
                transitionToFinalState = this.createPartialTransition(new NFAStateSet(this.dfaGen.getNfa(), successor.getUnAnchoredFinalStateTransition().getSource()), compilationBuffer);
            }
            if (successor.isAnchoredFinalState()) {
                transitionToAnchoredFinalState = this.createPartialTransition(new NFAStateSet(this.dfaGen.getNfa(), successor.getAnchoredFinalStateTransition().getSource()), compilationBuffer);
            }
            assert (this.getId() >= 0);
            if (this.getId() > Short.MAX_VALUE) {
                throw new UnsupportedRegexException("too many capture group transitions");
            }
            this.lazyTransition = new DFACaptureGroupLazyTransition((short)this.getId(), partialTransitions, transitionToFinalState, transitionToAnchoredFinalState);
        }
        return this.lazyTransition;
    }

    public static class PartialTransitionDebugInfo
    implements JsonConvertible {
        private DFACaptureGroupPartialTransition node;
        private final short[] resultToTransitionMap;

        public PartialTransitionDebugInfo(DFACaptureGroupPartialTransition node) {
            this(node, 0);
        }

        public PartialTransitionDebugInfo(int nResults) {
            this(null, nResults);
        }

        public PartialTransitionDebugInfo(DFACaptureGroupPartialTransition node, int nResults) {
            this.node = node;
            this.resultToTransitionMap = new short[nResults];
        }

        public DFACaptureGroupPartialTransition getNode() {
            return this.node;
        }

        public void mapResultToNFATransition(int resultNumber, NFAStateTransition transition) {
            this.resultToTransitionMap[resultNumber] = transition.getId();
        }

        @Override
        public JsonValue toJson() {
            return ((JsonObject)this.node.toJson()).append(Json.prop("resultToNFATransitionMap", Json.array(this.resultToTransitionMap)));
        }
    }
}

